/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class X509NameTest
implements Test {
    public String getName() {
        return "X509Name";
    }

    public TestResult perform() {
        Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
        hashtable.put(X509Name.C, "AU");
        hashtable.put(X509Name.O, "The Legion of the Bouncy Castle");
        hashtable.put(X509Name.L, "Melbourne");
        hashtable.put(X509Name.ST, "Victoria");
        hashtable.put(X509Name.E, "feedback-crypto@bouncycastle.org");
        X509Name x509Name = new X509Name(hashtable);
        if (!x509Name.equals(x509Name)) {
            return new SimpleTestResult(false, this.getName() + ": Failed same object test");
        }
        X509Name x509Name2 = new X509Name(hashtable);
        if (!x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed same name test");
        }
        Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
        vector.addElement(X509Name.C);
        vector.addElement(X509Name.O);
        vector.addElement(X509Name.L);
        vector.addElement(X509Name.ST);
        vector.addElement(X509Name.E);
        Vector<DERObjectIdentifier> vector2 = new Vector<DERObjectIdentifier>();
        vector2.addElement(X509Name.E);
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.L);
        vector2.addElement(X509Name.O);
        vector2.addElement(X509Name.C);
        x509Name = new X509Name(vector, hashtable);
        x509Name2 = new X509Name(vector2, hashtable);
        if (!x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed reverse name test");
        }
        vector2 = new Vector();
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.L);
        vector2.addElement(X509Name.O);
        vector2.addElement(X509Name.C);
        x509Name = new X509Name(vector, hashtable);
        x509Name2 = new X509Name(vector2, hashtable);
        if (x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed different name test");
        }
        vector2 = new Vector();
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.L);
        vector2.addElement(X509Name.O);
        vector2.addElement(X509Name.C);
        x509Name = new X509Name(vector, hashtable);
        x509Name2 = new X509Name(vector2, hashtable);
        if (x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed subset name test");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        X509NameTest x509NameTest = new X509NameTest();
        TestResult testResult = x509NameTest.perform();
        System.out.println(testResult);
    }
}

