/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.bouncycastle.jce.cert.CRLSelector;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertStoreSpi;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;

public class CertStoreCollectionSpi
extends CertStoreSpi {
    private CollectionCertStoreParameters params;

    public CertStoreCollectionSpi(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("org.bouncycastle.jce.provider.CertStoreCollectionSpi: parameter must be a CollectionCertStoreParameters object\n" + certStoreParameters.toString());
        }
        this.params = (CollectionCertStoreParameters)certStoreParameters;
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.params.getCollection().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Certificate) || !certSelector.match((Certificate)e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.params.getCollection().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CRL) || !cRLSelector.match((CRL)e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }
}

