/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERInputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.util.encoders.Hex;

public class JDKPKCS12KeyStore
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int STORE_VERSION = 1;
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 100;
    private static final String KEY_ALGORITHM = "1.2.840.113549.1.12.1.3";
    private static final String CERT_ALGORITHM = "1.2.840.113549.1.12.1.6";
    private static final String MAC_ALGORITHM = "1.3.14.3.2.26";
    private Hashtable keys = new Hashtable();
    private Hashtable localIds = new Hashtable();
    private Hashtable certs = new Hashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact = null;

    public JDKPKCS12KeyStore(String string) {
        try {
            this.certFact = string != null ? CertificateFactory.getInstance("X.509", string) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((DERConstructedSequence)new DERInputStream(byteArrayInputStream).readObject());
            return new SubjectKeyIdentifier(subjectPublicKeyInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.certs.get(string) != null || this.keys.get(string) != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.remove(string);
        Certificate certificate = (Certificate)this.certs.remove(string);
        if (certificate != null) {
            this.chainCerts.remove(new CertId(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = (String)this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new CertId(certificate.getPublicKey()));
            }
        }
        if (certificate == null && key == null) {
            throw new KeyStoreException("no such entry as " + string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = (Certificate)this.certs.get(string);
        if (certificate == null) {
            String string2 = (String)this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.certs.elements();
        Enumeration enumeration2 = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2 = (Certificate)enumeration.nextElement();
            String string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                Object object;
                Object object2;
                Object object3;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        object3 = new ByteArrayInputStream(byArray);
                        object2 = new DERInputStream((InputStream)object3);
                        object3 = new ByteArrayInputStream(((DEROctetString)((DERInputStream)object2).readObject()).getOctets());
                        object2 = new DERInputStream((InputStream)object3);
                        object = new AuthorityKeyIdentifier((DERConstructedSequence)((DERInputStream)object2).readObject());
                        if (((AuthorityKeyIdentifier)object).getKeyIdentifier() != null) {
                            certificate2 = (Certificate)this.chainCerts.get(new CertId(((AuthorityKeyIdentifier)object).getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(object3 = certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                    object = this.chainCerts.keys();
                    while (object.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(object.nextElement());
                        Principal principal = x509Certificate.getSubjectDN();
                        if (!principal.equals(object3)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                vector.addElement(certificate);
                certificate = certificate2 != certificate ? certificate2 : null;
            }
            certificateArray = new Certificate[vector.size()];
            int n = 0;
            while (n != certificateArray.length) {
                certificateArray[n] = (Certificate)vector.elementAt(n);
                ++n;
            }
            return certificateArray;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return (Key)this.keys.get(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.certs.get(string) != null && this.keys.get(string) == null;
    }

    public boolean engineIsKeyEntry(String string) {
        return this.keys.get(string) != null;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.certs.get(string) != null) {
            throw new KeyStoreException("There is already a certificate with the name " + string + ".");
        }
        this.certs.put(string, certificate);
        this.chainCerts.put(new CertId(certificate.getPublicKey()), certificate);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(string) != null && !key.equals((Key)this.keys.get(string))) {
            throw new KeyStoreException("There is already a key with the name " + string + ".");
        }
        this.keys.put(string, key);
        this.certs.put(string, certificateArray[0]);
        int n = 0;
        while (n != certificateArray.length) {
            this.chainCerts.put(new CertId(certificateArray[n].getPublicKey()), certificateArray[n]);
            ++n;
        }
    }

    public int engineSize() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray) throws IOException {
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((DERConstructedSequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        PrivateKey privateKey = null;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(4, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            privateKey = (PrivateKey)cipher.unwrap(byArray, "", 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        return privateKey;
    }

    protected byte[] wrapKey(String string, Key key, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray = cipher.wrap(key);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray;
    }

    protected DERConstructedSequence decryptData(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray) throws IOException {
        Object object;
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((DERConstructedSequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        byte[] byArray2 = null;
        try {
            object = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(2, (Key)((SecretKeyFactory)object).generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception decrypting data - " + exception.toString());
        }
        object = new BERInputStream(new ByteArrayInputStream(byArray2));
        return (DERConstructedSequence)((BERInputStream)object).readObject();
    }

    protected byte[] encryptData(String string, byte[] byArray, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray2;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(1, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray2;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n = bufferedInputStream.read();
        if (n != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        BERInputStream bERInputStream = new BERInputStream(bufferedInputStream);
        DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)bERInputStream.readObject();
        Pfx pfx = new Pfx(dERConstructedSequence);
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<SafeBag> vector = new Vector<SafeBag>();
        if (pfx.getMacData() != null) {
            object11 = new ByteArrayOutputStream();
            object10 = new BEROutputStream((OutputStream)object11);
            MacData macData = pfx.getMacData();
            object9 = macData.getMac();
            object8 = ((DigestInfo)object9).getAlgorithmId();
            byte[] byArray = macData.getSalt();
            int n2 = macData.getIterationCount().intValue();
            ((BEROutputStream)object10).writeObject(contentInfo);
            object7 = ((DEROctetString)contentInfo.getContent()).getOctets();
            try {
                object6 = Mac.getInstance(((AlgorithmIdentifier)object8).getObjectId().getId(), "BC");
                object5 = SecretKeyFactory.getInstance(((AlgorithmIdentifier)object8).getObjectId().getId(), "BC");
                object4 = new PBEParameterSpec(byArray, n2);
                object3 = new PBEKeySpec(cArray);
                ((Mac)object6).init(((SecretKeyFactory)object5).generateSecret((KeySpec)object3), (AlgorithmParameterSpec)object4);
                ((Mac)object6).update((byte[])object7);
                object2 = ((Mac)object6).doFinal();
                object = ((DigestInfo)object9).getDigest();
                if (((byte[])object2).length != ((DigestInfo)object9).getDigest().length) {
                    throw new IOException("PKCS12 key store mac invalid.");
                }
                int n3 = 0;
                while (n3 != ((byte[])object2).length) {
                    if (object2[n3] != object[n3]) {
                        throw new IOException("PKCS12 key store mac invalid.");
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new Hashtable();
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
            bERInputStream = new BERInputStream(new ByteArrayInputStream(((DEROctetString)contentInfo.getContent()).getOctets()));
            object11 = new AuthenticatedSafe((DERConstructedSequence)bERInputStream.readObject());
            object10 = ((AuthenticatedSafe)object11).getContentInfo();
            int n4 = 0;
            while (n4 != ((ContentInfo[])object10).length) {
                DERObject dERObject;
                SafeBag safeBag;
                int n5;
                if (object10[n4].getContentType().equals(PKCSObjectIdentifiers.data)) {
                    object9 = new DERInputStream(new ByteArrayInputStream(((DEROctetString)((ContentInfo)object10[n4]).getContent()).getOctets()));
                    object8 = (DERConstructedSequence)((DERInputStream)object9).readObject();
                    n5 = 0;
                    while (n5 != ((ASN1Sequence)object8).getSize()) {
                        safeBag = new SafeBag((DERConstructedSequence)((ASN1Sequence)object8).getObjectAt(n5));
                        if (safeBag.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                            object7 = new EncryptedPrivateKeyInfo((DERConstructedSequence)safeBag.getBagValue());
                            object6 = this.unwrapKey(((EncryptedPrivateKeyInfo)object7).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object7).getEncryptedData(), cArray);
                            object5 = (PKCS12BagAttributeCarrier)object6;
                            object4 = null;
                            object3 = null;
                            object2 = safeBag.getBagAttributes().getObjects();
                            while (object2.hasMoreElements()) {
                                object = (DERConstructedSequence)object2.nextElement();
                                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(0);
                                dERObject = (DERObject)((DERSet)((ASN1Sequence)object).getObjectAt(1)).getObjectAt(0);
                                object5.setBagAttribute(dERObjectIdentifier, dERObject);
                                if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                    object4 = ((DERBMPString)dERObject).getString();
                                    this.keys.put(object4, object6);
                                    continue;
                                }
                                if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                                object3 = (DEROctetString)dERObject;
                            }
                            object = new String(Hex.encode(((ASN1OctetString)object3).getOctets()));
                            if (object4 == null) {
                                this.keys.put(object, object6);
                            } else {
                                this.localIds.put(object4, object);
                            }
                        } else if (safeBag.getBagId().equals(PKCSObjectIdentifiers.certBag)) {
                            vector.addElement(safeBag);
                        } else {
                            System.out.println("extra " + safeBag.getBagId());
                            System.out.println("extra " + ASN1Dump.dumpAsString(safeBag));
                        }
                        ++n5;
                    }
                } else if (((ContentInfo)object10[n4]).getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
                    object9 = new EncryptedData((DERConstructedSequence)((ContentInfo)object10[n4]).getContent());
                    object8 = this.decryptData(((EncryptedData)object9).getEncryptionAlgorithm(), ((EncryptedData)object9).getContent().getOctets(), cArray);
                    n5 = 0;
                    while (n5 != ((ASN1Sequence)object8).getSize()) {
                        safeBag = new SafeBag((DERConstructedSequence)((ASN1Sequence)object8).getObjectAt(n5));
                        if (safeBag.getBagId().equals(PKCSObjectIdentifiers.certBag)) {
                            vector.addElement(safeBag);
                        } else if (safeBag.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                            object7 = new EncryptedPrivateKeyInfo((DERConstructedSequence)safeBag.getBagValue());
                            object6 = this.unwrapKey(((EncryptedPrivateKeyInfo)object7).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object7).getEncryptedData(), cArray);
                            object5 = (PKCS12BagAttributeCarrier)object6;
                            object4 = null;
                            object3 = null;
                            object2 = safeBag.getBagAttributes().getObjects();
                            while (object2.hasMoreElements()) {
                                object = (DERConstructedSequence)object2.nextElement();
                                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(0);
                                dERObject = (DERObject)((DERSet)((ASN1Sequence)object).getObjectAt(1)).getObjectAt(0);
                                object5.setBagAttribute(dERObjectIdentifier, dERObject);
                                if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                    object4 = ((DERBMPString)dERObject).getString();
                                    this.keys.put(object4, object6);
                                    continue;
                                }
                                if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                                object3 = (DEROctetString)dERObject;
                            }
                            object = new String(Hex.encode(((ASN1OctetString)object3).getOctets()));
                            if (object4 == null) {
                                this.keys.put(object, object6);
                            } else {
                                this.localIds.put(object4, object);
                            }
                        } else {
                            System.out.println("extra " + safeBag.getBagId());
                            System.out.println("extra " + ASN1Dump.dumpAsString(safeBag));
                        }
                        ++n5;
                    }
                } else {
                    System.out.println("extra " + ((ContentInfo)object10[n4]).getContentType().getId());
                    System.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object10[n4]).getContent()));
                }
                ++n4;
            }
        }
        this.certs = new Hashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        int n6 = 0;
        while (n6 != vector.size()) {
            Object object12;
            object10 = (SafeBag)vector.elementAt(n6);
            CertBag certBag = new CertBag((DERConstructedSequence)((SafeBag)object10).getBagValue());
            object9 = null;
            try {
                object8 = new ByteArrayInputStream(((DEROctetString)certBag.getCertValue()).getOctets());
                object9 = this.certFact.generateCertificate((InputStream)object8);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.toString());
            }
            object8 = null;
            String string = null;
            if (((SafeBag)object10).getBagAttributes() != null) {
                object12 = ((SafeBag)object10).getBagAttributes().getObjects();
                while (object12.hasMoreElements()) {
                    object7 = (DERConstructedSequence)object12.nextElement();
                    object6 = (DERObjectIdentifier)((ASN1Sequence)object7).getObjectAt(0);
                    object5 = (DERObject)((DERSet)((ASN1Sequence)object7).getObjectAt(1)).getObjectAt(0);
                    if (object9 instanceof PKCS12BagAttributeCarrier) {
                        object4 = (PKCS12BagAttributeCarrier)object9;
                        object4.setBagAttribute((DERObjectIdentifier)object6, (DEREncodable)object5);
                    }
                    if (((DERObjectIdentifier)object6).equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                        string = ((DERBMPString)object5).getString();
                        continue;
                    }
                    if (!((DERObjectIdentifier)object6).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                    object8 = (DEROctetString)object5;
                }
            }
            this.chainCerts.put(new CertId(((Certificate)object9).getPublicKey()), object9);
            if (string == null) {
                if (object8 != null) {
                    object12 = new String(Hex.encode(((ASN1OctetString)object8).getOctets()));
                    this.keyCerts.put(object12, object9);
                }
            } else {
                this.certs.put(string, object9);
            }
            ++n6;
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        DERObject dERObject;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        DEREncodable dEREncodable;
        Object object7;
        Object object8;
        Enumeration enumeration;
        DEREncodable dEREncodable2;
        DEREncodable dEREncodable3;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ContentInfo[] contentInfoArray = new ContentInfo[2];
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        Enumeration enumeration2 = this.keys.keys();
        while (enumeration2.hasMoreElements()) {
            object13 = new byte[20];
            this.random.nextBytes((byte[])object13);
            object12 = (String)enumeration2.nextElement();
            object11 = (PrivateKey)this.keys.get(object12);
            object10 = new PKCS12PBEParams((byte[])object13, 100);
            object9 = this.wrapKey(KEY_ALGORITHM, (Key)object11, (PKCS12PBEParams)object10, cArray);
            dEREncodable3 = new AlgorithmIdentifier(new DERObjectIdentifier(KEY_ALGORITHM), ((PKCS12PBEParams)object10).getDERObject());
            dEREncodable2 = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)dEREncodable3, (byte[])object9);
            boolean bl = false;
            enumeration = new DERConstructedSet();
            if (object11 instanceof PKCS12BagAttributeCarrier) {
                object8 = (PKCS12BagAttributeCarrier)object11;
                object7 = object8.getBagAttributeKeys();
                while (object7.hasMoreElements()) {
                    dEREncodable = (DERObjectIdentifier)object7.nextElement();
                    object6 = new DERConstructedSequence();
                    ((ASN1Sequence)object6).addObject(dEREncodable);
                    ((ASN1Sequence)object6).addObject(new DERSet(object8.getBagAttribute((DERObjectIdentifier)dEREncodable)));
                    bl = true;
                    ((ASN1Set)((Object)enumeration)).addObject((DEREncodable)object6);
                }
            }
            if (!bl) {
                object8 = new DERConstructedSequence();
                object7 = this.engineGetCertificate((String)object12);
                ((ASN1Sequence)object8).addObject(PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
                ((ASN1Sequence)object8).addObject(new DERSet(this.createSubjectKeyId(((Certificate)object7).getPublicKey())));
                ((ASN1Set)((Object)enumeration)).addObject((DEREncodable)object8);
                object8 = new DERConstructedSequence();
                ((ASN1Sequence)object8).addObject(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                ((ASN1Sequence)object8).addObject(new DERSet(new DERBMPString((String)object12)));
                ((ASN1Set)((Object)enumeration)).addObject((DEREncodable)object8);
            }
            object8 = new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, ((EncryptedPrivateKeyInfo)dEREncodable2).getDERObject(), (DERConstructedSet)((Object)enumeration));
            dERConstructedSequence.addObject((DEREncodable)object8);
        }
        object13 = new ByteArrayOutputStream();
        object12 = new DEROutputStream((OutputStream)object13);
        ((DEROutputStream)object12).writeObject(dERConstructedSequence);
        object11 = new BERConstructedOctetString(((ByteArrayOutputStream)object13).toByteArray());
        object10 = new byte[20];
        this.random.nextBytes((byte[])object10);
        object9 = new DERConstructedSequence();
        dEREncodable3 = new PKCS12PBEParams((byte[])object10, 100);
        dEREncodable2 = new AlgorithmIdentifier(new DERObjectIdentifier(CERT_ALGORITHM), ((PKCS12PBEParams)dEREncodable3).getDERObject());
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object8 = (String)enumeration.nextElement();
                object7 = this.engineGetCertificate((String)object8);
                boolean bl = false;
                object6 = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(((Certificate)object7).getEncoded()));
                object5 = new DERConstructedSet();
                if (object7 instanceof PKCS12BagAttributeCarrier) {
                    object4 = (PKCS12BagAttributeCarrier)object7;
                    object3 = object4.getBagAttributeKeys();
                    while (object3.hasMoreElements()) {
                        dERObject = (DERObjectIdentifier)object3.nextElement();
                        object2 = new DERConstructedSequence();
                        ((ASN1Sequence)object2).addObject(dERObject);
                        ((ASN1Sequence)object2).addObject(new DERSet(object4.getBagAttribute((DERObjectIdentifier)dERObject)));
                        ((ASN1Set)object5).addObject((DEREncodable)object2);
                        bl = true;
                    }
                }
                if (!bl) {
                    object4 = new DERConstructedSequence();
                    ((ASN1Sequence)object4).addObject(PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
                    ((ASN1Sequence)object4).addObject(new DERSet(this.createSubjectKeyId(((Certificate)object7).getPublicKey())));
                    ((ASN1Set)object5).addObject((DEREncodable)object4);
                    object4 = new DERConstructedSequence();
                    ((ASN1Sequence)object4).addObject(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                    ((ASN1Sequence)object4).addObject(new DERSet(new DERBMPString((String)object8)));
                    ((ASN1Set)object5).addObject((DEREncodable)object4);
                }
                object4 = new SafeBag(PKCSObjectIdentifiers.certBag, ((CertBag)object6).getDERObject(), (DERConstructedSet)object5);
                ((ASN1Sequence)object9).addObject((DEREncodable)object4);
                hashtable.put(object7, object7);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object8 = (String)enumeration.nextElement();
                object7 = (Certificate)this.certs.get(object8);
                boolean bl = false;
                if (hashtable.get(object7) != null) continue;
                object6 = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(((Certificate)object7).getEncoded()));
                object5 = new DERConstructedSet();
                if (object7 instanceof PKCS12BagAttributeCarrier) {
                    object4 = (PKCS12BagAttributeCarrier)object7;
                    object3 = object4.getBagAttributeKeys();
                    while (object3.hasMoreElements()) {
                        dERObject = (DERObjectIdentifier)object3.nextElement();
                        object2 = new DERConstructedSequence();
                        ((ASN1Sequence)object2).addObject(dERObject);
                        ((ASN1Sequence)object2).addObject(new DERSet(object4.getBagAttribute((DERObjectIdentifier)dERObject)));
                        ((ASN1Set)object5).addObject((DEREncodable)object2);
                        bl = true;
                    }
                }
                if (!bl) {
                    object4 = new DERConstructedSequence();
                    ((ASN1Sequence)object4).addObject(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                    ((ASN1Sequence)object4).addObject(new DERSet(new DERBMPString((String)object8)));
                    ((ASN1Set)object5).addObject((DEREncodable)object4);
                }
                object4 = new SafeBag(PKCSObjectIdentifiers.certBag, ((CertBag)object6).getDERObject(), (DERConstructedSet)object5);
                ((ASN1Sequence)object9).addObject((DEREncodable)object4);
                hashtable.put(object7, object7);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration = this.chainCerts.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object8 = (CertId)enumeration.nextElement();
                object7 = (Certificate)this.chainCerts.get(object8);
                if (hashtable.get(object7) != null) continue;
                dEREncodable = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(((Certificate)object7).getEncoded()));
                object6 = new DERConstructedSet();
                if (object7 instanceof PKCS12BagAttributeCarrier) {
                    object5 = (PKCS12BagAttributeCarrier)object7;
                    object4 = object5.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (DERObjectIdentifier)object4.nextElement();
                        dERObject = new DERConstructedSequence();
                        ((ASN1Sequence)dERObject).addObject((DEREncodable)object3);
                        ((ASN1Sequence)dERObject).addObject(new DERSet(object5.getBagAttribute((DERObjectIdentifier)object3)));
                        ((ASN1Set)object6).addObject(dERObject);
                    }
                }
                object5 = new SafeBag(PKCSObjectIdentifiers.certBag, ((CertBag)dEREncodable).getDERObject(), (DERConstructedSet)object6);
                ((ASN1Sequence)object9).addObject((DEREncodable)object5);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        ((ByteArrayOutputStream)object13).reset();
        object12 = new DEROutputStream((OutputStream)object13);
        ((DEROutputStream)object12).writeObject(object9);
        ((FilterOutputStream)object12).close();
        object8 = this.encryptData(CERT_ALGORITHM, ((ByteArrayOutputStream)object13).toByteArray(), (PKCS12PBEParams)dEREncodable3, cArray);
        object7 = new EncryptedData(PKCSObjectIdentifiers.data, (AlgorithmIdentifier)dEREncodable2, new BERConstructedOctetString((byte[])object8));
        contentInfoArray[0] = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)object11);
        contentInfoArray[1] = new ContentInfo(PKCSObjectIdentifiers.encryptedData, ((EncryptedData)object7).getDERObject());
        dEREncodable = new AuthenticatedSafe(contentInfoArray);
        ((ByteArrayOutputStream)object13).reset();
        object6 = new BEROutputStream((OutputStream)object13);
        ((BEROutputStream)object6).writeObject(dEREncodable);
        object5 = ((ByteArrayOutputStream)object13).toByteArray();
        object4 = new ContentInfo(PKCSObjectIdentifiers.data, new BERConstructedOctetString((byte[])object5));
        object3 = new byte[20];
        int n = 100;
        this.random.nextBytes((byte[])object3);
        object2 = ((DEROctetString)((ContentInfo)object4).getContent()).getOctets();
        MacData macData = null;
        try {
            object = Mac.getInstance(X509ObjectIdentifiers.id_SHA1.getId(), "BC");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(X509ObjectIdentifiers.id_SHA1.getId(), "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec((byte[])object3, n);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            ((Mac)object).init(secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            ((Mac)object).update((byte[])object2);
            byte[] byArray = ((Mac)object).doFinal();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, null);
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
            macData = new MacData(digestInfo, (byte[])object3, n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        object = new Pfx((ContentInfo)object4, macData);
        object6 = new BEROutputStream(outputStream);
        ((BEROutputStream)object6).writeObject(object);
    }

    public static class DefPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore() {
            super(null);
        }
    }

    public static class BCPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore() {
            super("BC");
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey publicKey) {
            this.id = JDKPKCS12KeyStore.this.createSubjectKeyId(publicKey).getKeyIdentifier();
        }

        CertId(byte[] byArray) {
            this.id = byArray;
        }

        public int hashCode() {
            int n = this.id[0] & 0xFF;
            int n2 = 1;
            while (n2 != this.id.length - 4) {
                n ^= (this.id[n2] & 0xFF) << 24 | (this.id[n2 + 1] & 0xFF) << 16 | (this.id[n2 + 2] & 0xFF) << 8 | this.id[n2 + 3] & 0xFF;
                ++n2;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CertId)) {
                return false;
            }
            CertId certId = (CertId)object;
            if (certId.id.length != this.id.length) {
                return false;
            }
            int n = 0;
            while (n != this.id.length) {
                if (certId.id[n] != this.id[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

