/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class BlockCipherTest
implements Test {
    static String[] cipherTests1 = new String[]{"DES", "466da00648ef0e1f9617b1f002e225251a3248d09172f46b9617b1f002e225250112ecb3da61bc99", "DESede", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "SKIPJACK", "d4de46d52274dbb029f33b076043f8c40089f906751623de29f33b076043f8c4ac99b90f9396cb04", "Blowfish", "25e15516062f0098e13ef22cab30289490a1db7887258a4fe13ef22cab302894b29698bcc4dd576e", "Twofish", "70336d9c9718a8a2ced1b19deed973a3c58af7ea71a69e7efc4df082dca581c0839e31468661bcfc57a14899ceeb0253", "RC2", "eb5b889bbcced12eb6b1a3da6a3d965bba66a5edfdd4c8a6b6b1a3da6a3d965b994a5b859e765797", "RC5", "220053543e3eca3bc9503a091ca67b08372560d8a4fdbee8c9503a091ca67b08a796d53bb8a4b7e0", "RC5-64", "cd672cc864456af6257814d6581573dcae96f986ff05c584ac961298eee2f45bc2567e7d725e0ecdd2cdbd3712ee125f", "RC6", "44c97b67ca8486067f8b6c5b97632f3049e5e52c1d61fdd527dc3da39616540f19a3db39aac1ffd713795cd886cce0c0", "IDEA", "8c9fd56823ffdc523f6ccf7f614aa6173553e594fc7a21b53f6ccf7f614aa61740c54f7a66e95108", "DES/CBC/NoPadding", "60fa2f8fae5aa2a38e9ac77d0246726beb7511e4515feb12cf99f75cc6e0122a", "DESede/CBC/NoPadding", "4d3d7931875cf25593dc402298add8b914761e4936c9585ae22b2c1441169231", "SKIPJACK/CBC/NoPadding", "ceebcc2e5e2b847f9ed797b4930b95f115b9e6cf49c457fc2ea0df79ad5c8334", "Blowfish/CBC/NoPadding", "f12382107340125cd2f873db67d76b8a3ca0f83662e83bbca5af7f00080bdb49", "Twofish/CBC/NoPadding", "f819694251a00bdd403928745cd1d8a094de61f49ddf8e7692e9d81a83812943", "RC2/CBC/NoPadding", "a51facdb3933c9676795cd38cc3146fd4694722b468b1a979a399c77606abf99", "RC5/CBC/NoPadding", "9ee7517eab0280445f3a7c60c90c0f75029d65bca8b1af83ace5399d388c83c3", "RC6/CBC/NoPadding", "c44695633c07010f3a0d8f7ea046a642d4a96bf4e44f89fd91b46830bc95b130", "IDEA/CBC/NoPadding", "30cd990ebdae80fe12b6c6e4fcd1c064a27d985c276b3d7097351c8684e4c4d9", "DES/CBC/PKCS5Padding", "60fa2f8fae5aa2a38e9ac77d0246726beb7511e4515feb12cf99f75cc6e0122afdc70484fb9c0232", "DES/CBC/ISO10126Padding", "60fa2f8fae5aa2a38e9ac77d0246726beb7511e4515feb12cf99f75cc6e0122a980639850a2cc3e8", "DES/CBC/X9.23Padding", "60fa2f8fae5aa2a38e9ac77d0246726beb7511e4515feb12cf99f75cc6e0122a980639850a2cc3e8", "DESede/CBC/PKCS7Padding", "4d3d7931875cf25593dc402298add8b914761e4936c9585ae22b2c1441169231a41e40695f1cff84", "SKIPJACK/CBC/PKCS7Padding", "ceebcc2e5e2b847f9ed797b4930b95f115b9e6cf49c457fc2ea0df79ad5c8334df7042de5db89c96", "Blowfish/CBC/PKCS7Padding", "f12382107340125cd2f873db67d76b8a3ca0f83662e83bbca5af7f00080bdb497968f18beabcc3aa", "Twofish/CBC/PKCS7Padding", "f819694251a00bdd403928745cd1d8a094de61f49ddf8e7692e9d81a838129433e5f1343d6cdb0b41838619da1541f04", "RC2/CBC/PKCS7Padding", "a51facdb3933c9676795cd38cc3146fd4694722b468b1a979a399c77606abf9958435525f770f137", "RC5/CBC/PKCS7Padding", "9ee7517eab0280445f3a7c60c90c0f75029d65bca8b1af83ace5399d388c83c3edd95ff49be76651", "RC5-64/CBC/PKCS7Padding", "8a36cf61c27d1ac32003d5242d1bcb8ad8512c632c74dda9b3c64747c52f333c2c1d494503b416d78cd273121b727530", "RC6/CBC/PKCS7Padding", "c44695633c07010f3a0d8f7ea046a642d4a96bf4e44f89fd91b46830bc95b130824b972c9019a69d2dd05ef2d36b37ac", "IDEA/CBC/PKCS7Padding", "30cd990ebdae80fe12b6c6e4fcd1c064a27d985c276b3d7097351c8684e4c4d9e584751325ef7c32", "IDEA/CBC/ISO10126Padding", "30cd990ebdae80fe12b6c6e4fcd1c064a27d985c276b3d7097351c8684e4c4d978b3fd73135f033b", "IDEA/CBC/X9.23Padding", "30cd990ebdae80fe12b6c6e4fcd1c064a27d985c276b3d7097351c8684e4c4d978b3fd73135f033b", "AES/CBC/PKCS7Padding", "cf87f4d8bb9d1abb36cdd9f44ead7d046db2f802d99e1ef0a5940f306079e08389a44c4a8cc1a47cbaee1128da55bbb7", "Rijndael/CBC/PKCS7Padding", "cf87f4d8bb9d1abb36cdd9f44ead7d046db2f802d99e1ef0a5940f306079e08389a44c4a8cc1a47cbaee1128da55bbb7", "Serpent/CBC/PKCS7Padding", "f8940ca31aba8ce1e0693b1ae0b1e08daef6de03c80f019774280052f824ac44540bb8dd74dfad47f83f9c7ec268ca68", "CAST5/CBC/PKCS7Padding", "87b6dc0c5a1d23d42fa740b0548be0b298112000544610d889d6361994cf8e670a19d6af72d7289f", "CAST6/CBC/PKCS7Padding", "943445569cfdda174118e433828f84e137faee38cac5c827d87a3c9a5a46a07dd64e7ad8accd921f248eea627cd6826f", "DES/CBC/WithCTS", "60fa2f8fae5aa2a38e9ac77d0246726bcf99f75cc6e0122aeb7511e4515feb12", "IDEA/CBC/PKCS7Padding", "30cd990ebdae80fe12b6c6e4fcd1c064a27d985c276b3d7097351c8684e4c4d9e584751325ef7c32", "DES/CBC/WithCTS", "60fa2f8fae5aa2a38e9ac77d0246726bcf99f75cc6e0122aeb7511e4515feb12", "DESede/CBC/WithCTS", "4d3d7931875cf25593dc402298add8b9e22b2c144116923114761e4936c9585a", "SKIPJACK/CBC/WithCTS", "ceebcc2e5e2b847f9ed797b4930b95f12ea0df79ad5c833415b9e6cf49c457fc", "Blowfish/CBC/WithCTS", "f12382107340125cd2f873db67d76b8aa5af7f00080bdb493ca0f83662e83bbc", "Twofish/CBC/WithCTS", "94de61f49ddf8e7692e9d81a83812943f819694251a00bdd403928745cd1d8a0", "AES/CBC/WithCTS", "6db2f802d99e1ef0a5940f306079e083cf87f4d8bb9d1abb36cdd9f44ead7d04", "Rijndael/CBC/WithCTS", "6db2f802d99e1ef0a5940f306079e083cf87f4d8bb9d1abb36cdd9f44ead7d04", "Serpent/CBC/WithCTS", "aef6de03c80f019774280052f824ac44f8940ca31aba8ce1e0693b1ae0b1e08d", "CAST5/CBC/WithCTS", "87b6dc0c5a1d23d42fa740b0548be0b289d6361994cf8e6798112000544610d8", "CAST6/CBC/WithCTS", "37faee38cac5c827d87a3c9a5a46a07d943445569cfdda174118e433828f84e1", "RC2/CBC/WithCTS", "a51facdb3933c9676795cd38cc3146fd9a399c77606abf994694722b468b1a97", "RC5/CBC/WithCTS", "9ee7517eab0280445f3a7c60c90c0f75ace5399d388c83c3029d65bca8b1af83", "RC6/CBC/WithCTS", "d4a96bf4e44f89fd91b46830bc95b130c44695633c07010f3a0d8f7ea046a642", "IDEA/CBC/WithCTS", "30cd990ebdae80fe12b6c6e4fcd1c06497351c8684e4c4d9a27d985c276b3d70", "DES/OFB/NoPadding", "537572e480c1714f5c9a4f3b874df824dc6681b1fd6c11982debcad91e3f78b7", "DESede/OFB/NoPadding", "481e9872acea7fcf8e29a453242da774e5f6a28f15f7723659a73e4ff4939f80", "SKIPJACK/OFB/NoPadding", "71143a124e3a0cde753b60fe9b200e559018b6a0fe0682659f7c13feb9df995c", "Blowfish/OFB/NoPadding", "134bcde441a6dd1cde0a0cdfd325e6f2cceabfe2a810f4eeec8ddd51bc2e65ae", "Twofish/OFB/NoPadding", "821c54b1b54ae113cf74595eefe10c83b61c9682fc81f92c52f39a3a693f88b8", "RC2/OFB/NoPadding", "0a07cb78537cb04c0c74e28a7b86b80f80acadf87d6ef32792f1a8cf74b39f74", "RC5/OFB/NoPadding", "c62b233df296283b918a2b4cc53a54fbf061850e781b97332ed1bd78b88d9670", "IDEA/OFB/NoPadding", "dd447da3cbdcf81f4053fb446596261cb00a3c49a66085485af5f7c10ba20dad", "DES/OFB8/NoPadding", "53cb5010d189f94cf584e5ff1c4a9d86443c45ddb6fa3c2d1a5dadfcdf01db8a", "DESede/OFB8/NoPadding", "482c0c1ccd0e6d218e1cffb0a295352c2357ffaa673f2257ef5c77b6c04f03b5", "SKIPJACK/OFB8/NoPadding", "719ea1b432b3d2c8011e5aa873f95978420022b5e2c9c1a1c1082cd1f4999da2", "Blowfish/OFB8/NoPadding", "13a7e65359228380ae522b327734aaabf749f9b555cce4c531f9a31cd659f679", "Twofish/OFB8/NoPadding", "825dcec234ad52253d6e064b0d769bc04b1142435933f4a510ffc20d70095a88", "RC2/OFB8/NoPadding", "0aa26c6f6a820fe7d38da97085995ad62e2e293323a76300fcd4eb572810f7c6", "RC5/OFB8/NoPadding", "c601a9074dbd874f4d3293f6a32d93d9f0a4f5685d8597f0102fcc96d444f976", "IDEA/OFB8/NoPadding", "dd7897b6ced43d060a518bb38d570308b83b4de577eb208130daabf619e9b1fb", "DES/CFB/NoPadding", "537572e480c1714fec3c7424f88d4202219244c5ca8f5e4361d64f08fe747bb2", "DESede/CFB/NoPadding", "481e9872acea7fcfb75bb58670fe64c59123265139e357d161cd4ddb5eba042a", "SKIPJACK/CFB/NoPadding", "71143a124e3a0cde70a69ede4ceb14376b1e6a80bafde0a6330508dfa86a7c41", "Blowfish/CFB/NoPadding", "134bcde441a6dd1c0d7522225e94d4a5083a61326ea1f930fc28864296c2bf2c", "Twofish/CFB/NoPadding", "821c54b1b54ae113cf74595eefe10c8308b7a438277de4f40948ac2d172d53d2", "RC2/CFB/NoPadding", "0a07cb78537cb04ca1401450d5cd411c7da7fa5b6baaa17bb2137bd95c9f26a5", "RC5/CFB/NoPadding", "c62b233df296283b989352bbebf616a19e11503ac737f9e0eaf19049cde05d34", "IDEA/CFB/NoPadding", "dd447da3cbdcf81fcbe4661dcbed88aed899f87585118384bd0565067fa6c13a", "DES/CFB8/NoPadding", "53cb0cdff712a825eb283b23c31e7323aa12495e7e751428b5c4eb89b28a25d4", "DESede/CFB8/NoPadding", "482cd5bf87ca4cee0b573d66a077231bfea93843ce2d1f948550a1d208e18279", "SKIPJACK/CFB8/NoPadding", "719eef3906bef23f7b63599285437d8e34183b165acf3e855b4e160d4f036508", "Blowfish/CFB8/NoPadding", "13a7674626f78b0ed58c4e55f9f5d90b97dd7926533ac8840af8c7c1a7ca8dd8", "Twofish/CFB8/NoPadding", "825d12af040721cf5ed4a4798647837ac5eb14d752aace28728aeb37b2010abd", "RC2/CFB8/NoPadding", "0aa227f94be3a32ff927c5d25647ea41d7c2a1e94012fc7f2ad6767b9664bce5", "RC5/CFB8/NoPadding", "c601cf88725411f119965b9cd38d6c313b91128ed7c98c7604cc62d9b210be79", "IDEA/CFB8/NoPadding", "dd7839d2525420d10f95eec23dbaf3463302c445972a28c563c2635191bc19af"};
    static String[] cipherTests2 = new String[]{"DES/OFB64/NoPadding", "537572e480c1714f5c9a4f3b874df824dc6681b1fd6c11982debcad91e", "DES/CFB64/NoPadding", "537572e480c1714fec3c7424f88d4202219244c5ca8f5e4361d64f08fe"};
    static byte[] input1 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
    static byte[] input2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c");
    static RC2ParameterSpec rc2Spec = new RC2ParameterSpec(128, Hex.decode("0123456789abcdef"));
    static RC5ParameterSpec rc5Spec = new RC5ParameterSpec(16, 16, 32, Hex.decode("0123456789abcdef"));
    static RC5ParameterSpec rc564Spec = new RC5ParameterSpec(16, 16, 64, Hex.decode("0123456789abcdef0123456789abcdef"));

    public String getName() {
        return "BlockCipher";
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult test(String string, byte[] byArray, byte[] byArray2) {
        Cipher cipher;
        Cipher cipher2;
        SecretKey secretKey;
        Object object;
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom();
        try {
            int n = string.indexOf(47);
            object = n > 0 ? string.substring(0, n) : string;
            KeyGenerator keyGenerator = KeyGenerator.getInstance((String)object, "BC");
            keyGenerator.init(fixedSecureRandom);
            secretKey = keyGenerator.generateKey();
            cipher2 = Cipher.getInstance(string, "BC");
            cipher = Cipher.getInstance(string, "BC");
            if (string.startsWith("RC2")) {
                cipher.init(1, (Key)secretKey, rc2Spec, (SecureRandom)fixedSecureRandom);
            } else if (string.startsWith("RC5")) {
                if (string.startsWith("RC5-64")) {
                    cipher.init(1, (Key)secretKey, rc564Spec, (SecureRandom)fixedSecureRandom);
                } else {
                    cipher.init(1, (Key)secretKey, rc5Spec, (SecureRandom)fixedSecureRandom);
                }
            } else {
                cipher.init(1, (Key)secretKey, (SecureRandom)fixedSecureRandom);
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed initialisation - " + exception.toString());
        }
        try {
            if (string.startsWith("RC2")) {
                cipher2.init(2, (Key)secretKey, rc2Spec);
            } else if (string.startsWith("RC5")) {
                if (string.startsWith("RC5-64")) {
                    cipher2.init(2, (Key)secretKey, rc564Spec, (SecureRandom)fixedSecureRandom);
                } else {
                    cipher2.init(2, (Key)secretKey, rc5Spec, (SecureRandom)fixedSecureRandom);
                }
            } else {
                object = cipher.getIV();
                if (object != null) {
                    try {
                        byte[] byArray3 = new byte[((Object)object).length - 1];
                        cipher2.init(2, (Key)secretKey, new IvParameterSpec(byArray3));
                        return new SimpleTestResult(false, this.getName() + ": failed to pick up short IV");
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])object);
                        cipher2.init(2, (Key)secretKey, ivParameterSpec);
                    }
                } else {
                    cipher2.init(2, secretKey);
                }
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed initialisation - " + exception.toString());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            int n = 0;
            while (n != byArray.length / 2) {
                cipherOutputStream.write(byArray[n]);
                ++n;
            }
            cipherOutputStream.write(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - " + iOException.toString());
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray4, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray4 = new byte[byArray.length];
            int n = 0;
            while (n != byArray.length / 2) {
                byArray4[n] = (byte)dataInputStream.read();
                ++n;
            }
            dataInputStream.readFully(byArray4, byArray.length / 2, byArray4.length - byArray.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - " + exception.toString());
        }
        if (!this.equalArray(byArray4, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed decryption - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray4)));
        }
        return new SimpleTestResult(true, this.getName() + ": " + string + " Okay");
    }

    public TestResult perform() {
        int n = 0;
        while (n != cipherTests1.length) {
            TestResult testResult = this.test(cipherTests1[n], input1, Hex.decode(cipherTests1[n + 1]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            n += 2;
        }
        int n2 = 0;
        while (n2 != cipherTests2.length) {
            TestResult testResult = this.test(cipherTests2[n2], input2, Hex.decode(cipherTests2[n2 + 1]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            n2 += 2;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        BlockCipherTest blockCipherTest = new BlockCipherTest();
        TestResult testResult = blockCipherTest.perform();
        System.out.println(testResult.toString());
    }

    private class FixedSecureRandom
    extends SecureRandom {
        byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};

        private FixedSecureRandom() {
        }

        public void nextBytes(byte[] byArray) {
            int n = 0;
            while (n + this.seed.length < byArray.length) {
                System.arraycopy(this.seed, 0, byArray, n, this.seed.length);
                n += this.seed.length;
            }
            System.arraycopy(this.seed, 0, byArray, n, byArray.length - n);
        }
    }
}

