<?xml version="1.0" encoding="UTF-8" ?>
<!--
Schematron
Generated by X-Meta 
Thu Jul 05 14:45:53 BST 2007
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="exslt">
  <sch:title>Schematron for RIMDemo</sch:title>
  <sch:ns prefix="hd" uri="http://www.govtalk.gov.uk/CM/envelope"/>
  <sch:ns prefix="dsig" uri="http://www.w3.org/2000/09/xmldsig#"/>
  <sch:ns prefix="rim" uri="http://www.govtalk.gov.uk/taxation/RIMDemo/07-08/1"/>
    <sch:pattern id="p2">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/rim:IRenvelope/rim:Example/rim:Income/rim:NetIncome">
        <sch:assert test=". &lt;= ../rim:GrossIncome" id="a1" diagnostics="errorCode.1 transactional.1 ">NetIncome must be less or equal to GrossIncome</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p3">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/rim:IRenvelope/rim:Example/rim:TaxToDate">
        <sch:assert test="../rim:Income/rim:GrossIncome or ../rim:Income/rim:NetIncome" id="a2" diagnostics="errorCode.2 transactional.2 ">If TaxToDate is present, GrossIncome or NetIncome must be present</sch:assert>
        <sch:assert test=". &lt;= ../rim:Income/rim:GrossIncome" id="a3" diagnostics="errorCode.3 transactional.3 ">TaxToDate must be less than or equal to GrossIncome</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p1">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/rim:IRenvelope/rim:Example">
        <sch:assert test="rim:BirthDate or rim:NINO" id="a0" diagnostics="errorCode.0 transactional.0 ">At least one of birth date or NINO must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
  <sch:diagnostics>
    <sch:diagnostic id="errorCode.0">RIM-DEMO-NINO.0</sch:diagnostic>
    <sch:diagnostic id="transactional.0">At least one of birth date or NINO must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.1">RIM-DEMO-NET-INCOME.0</sch:diagnostic>
    <sch:diagnostic id="transactional.1">NetIncome must be less or equal to GrossIncome</sch:diagnostic>
    <sch:diagnostic id="errorCode.2">RIM-DEMO-TAX-TO-DATE.0</sch:diagnostic>
    <sch:diagnostic id="transactional.2">If TaxToDate is present, GrossIncome or NetIncome must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.3">RIM-DEMO-TAX-TO-DATE.1</sch:diagnostic>
    <sch:diagnostic id="transactional.3">TaxToDate must be less than or equal to GrossIncome</sch:diagnostic>
  </sch:diagnostics>
</sch:schema>
