/**
 * $Id: AbstractElementProcessor.java,v 1.6 2006/08/10 15:19:11 dec Exp $
 */
package bizrules;

import java.util.List;

import processingError.NullErrorCollector;
import processingError.ProcessingErrorCollector;
import xmldoc.DocumentError;
import xmldoc.sax.XPathLocator;
import bizrules.binding.*;

/**
 * @author Douglas Clinton
 * @since Feb 14, 2006
 * 
 */
public abstract class AbstractElementProcessor implements ElementProcessor {

    private ProcessingErrorCollector errorCollector = NullErrorCollector.instance();

    private ValueBinder valueBinder;

    private EventBinder eventBinder;

    private ErrorBinder errorBinder;

    private XPathLocator xPathLocator = null;

    protected ValueBinder getValueBinder() {
        if (valueBinder == null)
            valueBinder = new ValueBinder(getApplicableNamespaces(), getBoundObject());
        return valueBinder;
    }

    protected EventBinder getEventBinder() {
        if (eventBinder == null)
            eventBinder = new EventBinder(getApplicableNamespaces(), getBoundObject());
        return eventBinder;
    }

    protected ErrorBinder getErrorBinder() {
        if (errorBinder == null)
            errorBinder = new ErrorBinder(getApplicableNamespaces(), getBoundObject());
        return errorBinder;
    }

    /**
     * Default is to not handle errors. Subclasses can override if they want to
     * deal with errors. In particular, AbstractBusinessRule provides a generic
     * implementation.
     */
    public boolean handleError(final DocumentError error) {
        return false;
    }

    public void postRegistrationSetup() {
        // do nothing
    }

    public AbstractElementProcessor() {
    }

    protected Object getBoundObject() {
        return this;
    }

    protected abstract String[] getApplicableNamespaces();

    public ProcessingErrorCollector getErrorCollector() {
        return errorCollector;
    }

    public void setErrorCollector(final ProcessingErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    public void addValueBinding(final String xpath, final String propertyName) {
        getValueBinder().add(xpath, propertyName);
    }

    public void addEventBinding(final String xpath, final String methodName) {
        getEventBinder().add(xpath, methodName);
    }

    public void addErrorBinding(final String xpath, final String methodName) {
        getErrorBinder().add(xpath, methodName);
    }

    /**
     * We always want to bind submissionType and returnType. Other bindings are
     * delegated to a template method.
     */
    public List<ElementBinding> getValueBindings() {
        initializeValueBindings();
        return getValueBinder().getBindings();
    }

    public List<DocumentEventBinding> getEventBindings() {
        initializeEventBindings();
        return getEventBinder().getBindings();
    }

    public List<DocumentErrorBinding> getErrorBindings() {
        initializeErrorBindings();
        return getErrorBinder().getBindings();
    }

    protected abstract void initializeEventBindings();

    protected abstract void initializeValueBindings();

    protected void initializeErrorBindings() {
        // no error bindings by default
    }

    public XPathLocator getXPathLocator() {
        return xPathLocator;
    }

    public void setXPathLocator(final XPathLocator pathLocator) {
        xPathLocator = pathLocator;
    }
}
