/**
 * $Id: BusinessRule.java,v 1.2 2006/03/27 08:19:02 dec Exp $
 */
package bizrules;

import java.util.List;

import xmldoc.ElementReference;
import bizrules.registry.BusinessRuleRegistryAccess;

/**
 * This interface describes the behaviour of a standard Business Rule.
 * 
 * @author Douglas Clinton
 * @since Jan 5, 2006
 */
public interface BusinessRule extends ElementProcessor {

    /**
     * This method is called when the rule is ready to be invoked. (i.e. at the
     * end tag of the element to which it is attached.)
     */
    void processRule();

    /**
     * 
     * @return a list of ElementReferences which says which elements this rule
     *         should be attached to. The processRule() method will be called at
     *         the end tag of each of these elements.
     */
    List<ElementReference> getAttachmentPoints();

    /**
     * @return the name of the Rule
     */
    String getName();

    /**
     * @return true if the rule is active and should be invoked, false if it is
     *         inactive.
     */
    boolean isActive();

    /**
     * This gives a rule limited access back to the registry if it needs it.
     */
    void setBusinessRuleRegistryAccess(BusinessRuleRegistryAccess access);
}
