/**
 * $Id: BusinessRuleError.java,v 1.6 2006/08/10 15:19:11 dec Exp $
 */
package bizrules;

import java.util.ArrayList;
import java.util.List;

import processingError.ErrorProcessor;
import processingError.Location;
import processingError.ProcessingError;

/**
 * @author Douglas Clinton
 * @since Jan 6, 2006
 * 
 */
public class BusinessRuleError implements ProcessingError {

    protected BusinessRule rule;

    protected String subCode;

    protected Object valueInError;

    protected Object extraInfo;

    protected Location location;

    protected ErrorProcessor errorProcessor;

    protected ProcessingError chainedError = null;

    protected String errorCode;

    protected String message;

    private final List<Object> applicationData = new ArrayList<Object>();

    private String xPathLocation = null;

    public BusinessRuleError(final BusinessRule rule, final String subCode) {
        this.rule = rule;
        this.subCode = subCode;
    }

    public String getRuleName() {
        return rule.getName();
    }

    public Object getValueInError() {
        return valueInError;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getDescription() {
        return getRuleName() + "." + getSubCode();
    }

    public String getDetailedDescription() {
        return "";
    }

    public String getTagName() {
        return "";
    }

    public String getSubCode() {
        return subCode;
    }

    public Object getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(final Object extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public String toString() {
        return "BusinessRule:" + rule.toString() + ", subCode:" + subCode + ", valueInError:'" + valueInError + "'";
    }

    public ErrorProcessor getErrorProcessor() {
        return errorProcessor;
    }

    public void setErrorProcessor(final ErrorProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
    }

    public ProcessingError getChainedError() {
        return chainedError;
    }

    public void setChainedError(final ProcessingError chainedError) {
        this.chainedError = chainedError;
    }

    public List<?> getApplicationData() {
        return applicationData;
    }

    public void addApplicationData(final Object datum) {
        applicationData.add(datum);
    }

    /**
     * BusinessRuleErrors can only chain other ProcessingErrors or nothing.
     */
    public Object getOriginalError() {
        if (chainedError != null) {
            return chainedError.getOriginalError();
        } else {
            return this;
        }
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(final String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(final String message) {
        this.message = message;
    }

    public void setLocation(final Location location) {
        this.location = location;
    }

    public void setValueInError(final Object valueInError) {
        this.valueInError = valueInError;
    }

    public String getXPathLocation() {
        return xPathLocation;
    }

    public void setXPathLocation(final String pathLocation) {
        xPathLocation = pathLocation;
    }
}
