/**
 * $Id: ElementProcessor.java,v 1.6 2006/08/10 15:19:11 dec Exp $
 */
package bizrules;

import processingError.ProcessingErrorCollector;
import xmldoc.sax.XPathLocator;
import bizrules.binding.DocumentEventListener;
import bizrules.binding.ElementValueListener;

/**
 * @author Douglas Clinton
 * @since Feb 14, 2006
 * 
 */
public interface ElementProcessor extends ElementValueListener, DocumentEventListener {
    ProcessingErrorCollector getErrorCollector();

    public void setErrorCollector(ProcessingErrorCollector errorCollector);

    public void setXPathLocator(XPathLocator xPathLocator);

    /**
     * This method provides a hook for an ElementProcessor to do any additional
     * initialization. It is guaranteed to be called after all other setup of
     * the processor is done.
     */
    void postRegistrationSetup();
}
