package bizrules.binding;

import java.lang.reflect.Method;

import xmldoc.ElementReference;

import com.gsl.util.reflection.MethodLocator;
import com.gsl.util.reflection.MethodLocatorCache;
import com.gsl.util.reflection.SetterMethodLocator;

public abstract class AbstractElementBinding implements ElementBinding {
    private final ElementReference reference;

    private final Object boundObject;

    private final String boundProperty;

    private final Method setter;

    private String elementText = "";

    protected AbstractElementBinding(ElementReference reference, Object boundObject, String boundProperty, Method setter) {
        this.reference = reference;
        this.boundObject = boundObject;
        this.boundProperty = boundProperty;
        this.setter = setter;

    }

    public boolean wantsValue() {
        return false;
    }

    public interface ElementBindingMaker<T extends ElementBinding> {
        Method locateMethod(Object boundObject, String propertyName);

        T makeBinding(ElementReference reference, Object boundObject, String propertyName, Method setter);
    }

    public void reset() {
        if (this.wantsValue()) {
            this.elementText = "";
        }
    }

    public void setElementText(String v) {
        if (wantsValue())
            elementText = v;
    }

    protected String getValue() {
        return elementText;
    }

    public ElementReference getReference() {
        return reference;
    }

    public Object getBoundObject() {
        return boundObject;
    }

    public String getBoundProperty() {
        return boundProperty;
    }

    protected Method getSetter() {
        return setter;
    }
}

abstract class AbstractElementBindingMaker<T extends ElementBinding> implements AbstractElementBinding.ElementBindingMaker<T> {
    private final MethodLocator locator = new MethodLocatorCache(new SetterMethodLocator(getSignature()));

    public Method locateMethod(Object boundObject, String propertyName) {
        return locator.locateMethod(boundObject.getClass(), propertyName);
    }

    protected abstract Class<?>[] getSignature();

    public abstract T makeBinding(ElementReference reference, Object boundObject, String propertyName, Method setter);
}
