/**
 * 
 */
package bizrules.binding;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import xmldoc.Attribute;
import xmldoc.ElementReference;

import com.gsl.logging.LoggerFactory;

/**
 * 
 * A binding for an object that is only interested in the attributes of the
 * element. These will be set at the start of the element. No action will be
 * taken on endElement.
 * 
 * @author doug
 * 
 */
public class AttributesBinding extends AbstractElementBinding {
    private static final Logger logger = LoggerFactory.getLogger("bizrules.binding");

    public static final Class<?>[] SIGNATURE = { Attribute[].class };

    public AttributesBinding(ElementReference reference, Object boundObject, String boundProperty, Method setter) {
        super(reference, boundObject, boundProperty, setter);
    }

    public static final ElementBindingMaker<AttributesBinding> bindingMaker = new AbstractElementBindingMaker<AttributesBinding>() {
        @Override
        protected Class<?>[] getSignature() {
            return AttributesBinding.SIGNATURE;
        }

        @Override
        public AttributesBinding makeBinding(ElementReference reference, Object boundObject, String propertyName,
                Method setter) {
            return new AttributesBinding(reference, boundObject, propertyName, setter);
        }
    };

    /**
     * Will invoke the setter on the bound object to provide the attributes of
     * the element.
     */
    public void startElement(Attribute[] attributes) {
        try {
            getSetter().invoke(getBoundObject(), new Object[] { attributes });
        } catch (final Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void endElement() {
        // do nothing
    }

    @Override
    public boolean wantsValue() {
        return false;
    }

}
