package bizrules.binding;

import xmldoc.ElementReference;

/**
 * @author Douglas Clinton
 * @since Jan 17, 2006
 */
public class BindingError extends Error {
    private final Object boundObject;

    /**
     * @directed true
     */

    private final ElementReference reference;

    private final String bindTo;

    public BindingError(final Object boundObject, final ElementReference reference, final String bindTo) {
        super("Failed to bind property " + bindTo + " on object " + boundObject + " for reference " + reference);

        this.boundObject = boundObject;
        this.reference = reference;
        this.bindTo = bindTo;
    }

    public String getBindTo() {
        return bindTo;
    }

    public Object getBoundObject() {
        return boundObject;
    }

    public ElementReference getReference() {
        return reference;
    }
}