package bizrules.binding;

import xmldoc.Attribute;
import xmldoc.ElementReference;

/**
 * An ElementBinding provides a link between an element in the document, defined
 * by an ElementReference, and a setter on an object, e.g. a business rule
 * object.
 * 
 * The ElementBinding has a very strict lifecyle that defines the order in which
 * it's methods should be called. Any variation to this order will result in
 * defined behaviour.
 * 
 * <ul>
 * <li>Construction [once per document]</li>
 * <li>startElement [once per matching element]</li>
 * <li>elementText [0 or more times per matching element]</li>
 * <li>endElement [once per matching element]</li>
 * <li>reset [once per matching element]</li>
 * </ul>
 * 
 * @author doug
 * 
 */
public interface ElementBinding {
    /**
     * 
     * @return the ElementReference of the element that this binding is attached
     *         to.
     */
    ElementReference getReference();

    /**
     * Signals that the start of the element was reached (i.e. its opening tag).
     * 
     * @param ref
     *            the ElementReference for the element that has ended
     * @param attributes
     *            The list of attributes for the element. If this binding
     *            returns false from its its <code>wantsAttributes</code> method
     *            then this parameter may well be null.
     */
    void startElement(Attribute[] attributes);

    /**
     * Signals that the end of the element was reached (i.e. its closing tag).
     * 
     * @param ref
     *            the ElementReference for the element that has ended
     * @param value
     *            the textual value of the element. Note that if this
     *            ElementBinding returns false from its <code>wantsValue</code>
     *            method then this parameter may well be null.
     */
    void endElement();

    /**
     * This will be called after endElement to give the binding a chance to
     * reset any state that it needs to
     */
    void reset();

    boolean wantsValue();

    void setElementText(String b);

    Object getBoundObject();

    Object getBoundProperty();

}
