/*
 * Created on 24-Jan-2006
 *
 * $Id: ErrorBinder.java,v 1.4 2006/08/10 15:19:11 dec Exp $
 */
package bizrules.binding;

import java.util.ArrayList;
import java.util.List;

import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class ErrorBinder {

    private final List<DocumentErrorBinding> bindings = new ArrayList<DocumentErrorBinding>();

    private final Object boundObject;

    private final String[] namespaces;

    public ErrorBinder(final String[] namespaces, final Object boundObject) {
        this.namespaces = namespaces;
        this.boundObject = boundObject;
    }

    public ErrorBinder(final String namespace, final Object boundObject) {
        this(new String[] { namespace }, boundObject);
    }

    public void add(final String xPath, final String methodName) {
        for (final String namespace : namespaces) {
            add(namespace, xPath, methodName);
        }
    }

    public void add(final String xPath, final String[] methodNames) {
        for (final String namespace : namespaces) {
            final ElementReference ref = SimpleElementReference.makeReference(namespace, xPath);
            final DocumentErrorBinding binding = new DocumentErrorBinding(this.boundObject, ref, methodNames);
            bindings.add(binding);
        }
    }

    public void add(final String namespace, final String xPath, final String methodName) {
        add(namespace, xPath, methodName, this.boundObject);
    }

    public void add(final String xPath, final String methodName, final Object boundObj) {
        for (final String element : namespaces) {
            add(element, xPath, methodName, boundObj);
        }
    }

    public void add(final String namespace, final String xPath, final String methodName, final Object boundObj) {
        add(SimpleElementReference.makeReference(namespace, xPath), methodName, boundObj);
    }

    public void add(final ElementReference ref, final String methodName) {
        add(ref, methodName, this.boundObject);
    }

    public void add(final ElementReference ref, final String methodName, final Object boundObj) {
        add(new DocumentErrorBinding(boundObj, ref, methodName));
    }

    public void add(final DocumentErrorBinding binding) {
        bindings.add(binding);
    }

    public List<DocumentErrorBinding> getBindings() {
        return bindings;
    }
}
