/*
 * Created on 24-Jan-2006
 *
 * $Id: EventBinder.java,v 1.5 2006/08/10 15:19:11 dec Exp $
 */
package bizrules.binding;

import java.util.ArrayList;
import java.util.List;

import xmldoc.DocumentEventType;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

/**
 * This is a utility class to create and collect event bindings.
 * 
 * @author rob austin
 */
public class EventBinder {

    private final List<DocumentEventBinding> bindings = new ArrayList<DocumentEventBinding>();

    private final Object boundObject;

    private final String[] namespaces;

    public EventBinder(final String[] namespaces, final Object boundObject) {
        this.namespaces = namespaces;
        this.boundObject = boundObject;
    }

    public EventBinder(final String namespace, final Object boundObject) {
        this(new String[] { namespace }, boundObject);
    }

    /**
     * @param xPath
     *            the xPath
     * 
     * Note defaults the DocumentEventType to START_ELEMENT
     */
    public void add(final String xPath, final String methodName) {
        add(xPath, methodName, DocumentEventType.startElement);
    }

    public void add(final String xPath, final String methodName, final DocumentEventType eventType) {
        for (final String element : namespaces) {
            add(element, xPath, methodName, eventType);
        }
    }

    public void add(final String namespace, final String xPath, final String methodName, final DocumentEventType eventType) {
        add(namespace, xPath, methodName, this.boundObject, eventType);
    }

    public void add(final String xPath, final String methodName, final Object boundObj, final DocumentEventType eventType) {
        for (final String element : namespaces) {
            add(element, xPath, methodName, boundObj, eventType);
        }
    }

    public void add(final String namespace, final String xPath, final String methodName, final Object boundObj,
            final DocumentEventType eventType) {
        add(SimpleElementReference.makeReference(namespace, xPath), methodName, boundObj, eventType);
    }

    public void add(final ElementReference ref, final String methodName, final DocumentEventType eventType) {
        add(ref, methodName, this.boundObject, eventType);
    }

    public void add(final ElementReference ref, final String methodName, final Object boundObj, final DocumentEventType eventType) {
        add(new DocumentEventBinding(boundObj, ref, methodName, eventType));
    }

    public void add(final DocumentEventBinding binding) {
        bindings.add(binding);
    }

    public List<DocumentEventBinding> getBindings() {
        return bindings;
    }
}
