package bizrules.binding;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import xmldoc.Attribute;
import xmldoc.ElementReference;

import com.gsl.logging.LoggerFactory;

/**
 * A binding that calls the setter with the ElementReference of the element it
 * was bound to. This seems odd when the ElementReference forms part of the
 * binding, however it is useful in cases where multiple paths, or the same path
 * from multiple namespaces are bound to the same setter and the bound object
 * wants to be able to tell which binding triggered the event.
 * 
 * @author doug
 * 
 */
public class ReferenceBinding extends AbstractElementBinding {

    private static final Logger logger = LoggerFactory.getLogger("bizrules.binding");

    public static final Class<?>[] SIGNATURE = { ElementReference.class };

    public ReferenceBinding(ElementReference reference, Object boundObject, String propertyName, Method setter) {
        super(reference, boundObject, propertyName, setter);
    }

    public static final ElementBindingMaker<ReferenceBinding> bindingMaker = new AbstractElementBindingMaker<ReferenceBinding>() {
        @Override
        protected Class<?>[] getSignature() {
            return ReferenceBinding.SIGNATURE;
        }

        @Override
        public ReferenceBinding makeBinding(ElementReference reference, Object boundObject, String propertyName,
                Method setter) {
            return new ReferenceBinding(reference, boundObject, propertyName, setter);
        }
    };

    public void startElement(Attribute[] attributes) {
        try {
            getSetter().invoke(getBoundObject(), new Object[] { getReference() });
        } catch (final Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void endElement() {
        // do nothing
    }

    @Override
    public boolean wantsValue() {
        return false;
    }

}
