/**
 * 
 */
package bizrules.binding;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import xmldoc.Attribute;
import xmldoc.ElementReference;

import com.gsl.logging.LoggerFactory;

/**
 * 
 * This binding will set both the element value and the attributes on
 * endElement. It is stateful in that it caches the attributes on startElement
 * so that they're available at endElement.
 * 
 * @author doug
 * 
 */
public final class ValueAttributesBinding extends AbstractElementBinding {
    private static final Logger logger = LoggerFactory.getLogger("bizrules.binding");

    public static final Class<?>[] SIGNATURE = { String.class, Attribute[].class };

    /**
     * A place to cache the attributes on startElement so that they're available
     * to pass to the setter method at the endElement.
     */
    private Attribute[] attributes = null;

    public ValueAttributesBinding(ElementReference reference, Object boundObject, String propertyName, Method setter) {
        super(reference, boundObject, propertyName, setter);
    }

    public static final ElementBindingMaker<ValueAttributesBinding> bindingMaker = new AbstractElementBindingMaker<ValueAttributesBinding>() {
        @Override
        protected Class<?>[] getSignature() {
            return ValueAttributesBinding.SIGNATURE;
        }

        @Override
        public ValueAttributesBinding makeBinding(ElementReference reference, Object boundObject, String propertyName,
                Method setter) {
            return new ValueAttributesBinding(reference, boundObject, propertyName, setter);
        }
    };

    public void endElement() {
        try {
            getSetter().invoke(getBoundObject(), new Object[] { getValue(), attributes });
        } catch (final Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void startElement(Attribute[] attributes) {
        // Cache the attributes for use at endElement
        this.attributes = attributes;
    }

    @Override
    public boolean wantsValue() {
        return true;
    }

}
