package bizrules.binding;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import bizrules.binding.AbstractElementBinding.ElementBindingMaker;

public class ValueBinder {
    private final List<ElementBinding> bindings = new ArrayList<ElementBinding>();

    private final Object boundObject;

    private final String[] namespaces;

    public ValueBinder(final String[] namespaces, final Object boundObject) {
        this.namespaces = namespaces;
        this.boundObject = boundObject;
    }

    public ValueBinder(final String namespace, final Object boundObject) {
        this(new String[] { namespace }, boundObject);
    }

    public void add(final String xPath, final String propertyName) {
        for (final String element : namespaces) {
            add(element, xPath, propertyName);
        }
    }

    public void add(final String namespace, final String xPath, final String propertyName) {
        add(namespace, xPath, propertyName, this.boundObject);
    }

    public void add(final String xPath, final String propertyName, final Object boundObj) {
        for (final String element : namespaces) {
            add(element, xPath, propertyName, boundObj);
        }
    }

    public void add(final String namespace, final String xPath, final String propertyName, final Object boundObj) {
        add(SimpleElementReference.makeReference(namespace, xPath), propertyName, boundObj);
    }

    public void add(final ElementReference ref, final String propertyName) {
        add(ref, propertyName, this.boundObject);
    }

    private static List<ElementBindingMaker<?>> bindingTypes = new ArrayList<ElementBindingMaker<?>>();

    static {
        bindingTypes.add(ValueBinding.bindingMaker);
        bindingTypes.add(ReferenceBinding.bindingMaker);
        bindingTypes.add(AttributesBinding.bindingMaker);
        bindingTypes.add(ValueAttributesBinding.bindingMaker);
    }

    public void add(final ElementReference ref, final String propertyName, final Object boundObj) {
        for (ElementBindingMaker<?> maker : bindingTypes) {
            Method method = maker.locateMethod(boundObj, propertyName);
            if (method != null)
                add(maker.makeBinding(ref, boundObj, propertyName, method));
        }
    }

    public void add(final ElementBinding binding) {
        bindings.add(binding);
    }

    public List<ElementBinding> getBindings() {
        return bindings;
    }
}
