package bizrules.binding;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import xmldoc.Attribute;
import xmldoc.ElementReference;

import com.gsl.logging.LoggerFactory;

/**
 * Represents a binding of the value of the element to a setter on an object.
 * I.e. a method with a signature of
 * <p>
 * <code>void setProperty(String value)</code>
 * </p>
 * 
 * @author doug
 * 
 */
public class ValueBinding extends AbstractElementBinding {
    private static final Logger logger = LoggerFactory.getLogger("bizrules.binding");

    public static final Class<?>[] SIGNATURE = { String.class };

    public ValueBinding(ElementReference reference, Object boundObject, String propertyName, Method setter) {
        super(reference, boundObject, propertyName, setter);
    }

    public static final ElementBindingMaker<ValueBinding> bindingMaker = new AbstractElementBindingMaker<ValueBinding>() {
        @Override
        protected Class<?>[] getSignature() {
            return ValueBinding.SIGNATURE;
        }

        @Override
        public ValueBinding makeBinding(ElementReference reference, Object boundObject, String propertyName,
                Method setter) {
            return new ValueBinding(reference, boundObject, propertyName, setter);
        }
    };

    public void endElement() {
        try {
            getSetter().invoke(getBoundObject(), new Object[] { getValue() });
        } catch (final Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void startElement(Attribute[] attributes) {
        // do nothing - can't set the value until the end element
    }

    @Override
    public boolean wantsValue() {
        return true;
    }
}
