/*
 * Created on Jul 18, 2005
 *
 * $Id: MonetaryDiscrepancy.java,v 1.1 2006/08/10 15:19:11 dec Exp $
 */
package bizrules.errors;

import java.math.BigDecimal;

/**
 * @author Doug Clinton
 * @since Jul 18, 2005
 */
public class MonetaryDiscrepancy {
    private final BigDecimal calculated;

    private final BigDecimal supplied;

    public MonetaryDiscrepancy(final BigDecimal calculated, final BigDecimal supplied) {
        this.calculated = calculated;
        this.supplied = supplied;
    }

    /**
     * 
     * @return the absolute value of the difference between the supplied and the
     *         calculated values.
     */
    public BigDecimal getDiscrepancy() {
        return calculated.subtract(supplied).abs();
    }

    public BigDecimal getSuppliedValue() {
        return supplied;
    }

    public BigDecimal getCalculatedValue() {
        return calculated;
    }

    @Override
    public String toString() {
        return "calculatedValue=" + getCalculatedValue() + ":suppliedValue=" + getSuppliedValue() + ":discrepancy="
                + getDiscrepancy();
    }
}
