/**
 * 
 */
package bizrules.params;

/**
 * A set of parameters than can affect the way business rules are dealt with. An
 * parameters for the bizrules project should be placed in here.
 * 
 * @author Doug Clinton
 * 
 */
public class BizrulesParams implements Cloneable {
    /**
     * If this is set to true then business rules will always be collected by
     * scanning the classpath dynamically. If false, then the collector will
     * make use of a properties file to find the classes if it is available.
     * 
     * The default is false.
     */
    private boolean forceDynamicClassCollection = false;

    /**
     * Setting this to true will cause the validator to stop processing business
     * rules if any XML or Schema errors are encountered.
     */
    private boolean ignoreBusinessRulesFollowingDocumentError = false;

    /**
     * Setting this to true will prevent the validator from applying any
     * business rules at all. Use this in the case where you just want XML and
     * Schema validation to be applied.
     */
    private boolean ignoreBusinessRules = false;

    @Override
    public String toString() {
        String s = "BizrulesParams [";
        s += "forceDynamicClassCollection=" + forceDynamicClassCollection;
        s += ", ";
        s += "ignoreBusinessRulesFollowingDocumentError=" + ignoreBusinessRulesFollowingDocumentError;
        s += ", ";
        s += "ignoreBusinessRules=" + ignoreBusinessRules;
        s += "]";

        return s;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean getForceDynamicClassCollection() {
        return forceDynamicClassCollection;
    }

    public void setForceDynamicClassCollection(final boolean forceDynamicClassCollection) {
        this.forceDynamicClassCollection = forceDynamicClassCollection;
    }

    public boolean getIgnoreBusinessRulesFollowingDocumentError() {
        return ignoreBusinessRulesFollowingDocumentError;
    }

    public void setIgnoreBusinessRulesFollowingDocumentError(final boolean ignoreBusinessRulesFollowingDocumentError) {
        this.ignoreBusinessRulesFollowingDocumentError = ignoreBusinessRulesFollowingDocumentError;
    }

    public boolean getIgnoreBusinessRules() {
        return ignoreBusinessRules;
    }

    public void setIgnoreBusinessRules(final boolean ignoreBusinessRules) {
        this.ignoreBusinessRules = ignoreBusinessRules;
    }

}
