package bizrules.registry;

import xmldoc.DocumentEventReceiver;
import bizrules.BusinessRule;
import bizrules.ElementProcessor;
import bizrules.binding.ElementBinding;

public interface BusinessRuleRegistry extends DocumentEventReceiver {

    void registerBusinessRule(BusinessRule rule);

    void registerElementProcessor(ElementProcessor processor);

    void registerNamespaceHandler(NamespaceHandler namespaceHandler);

    /**
     * This method can be used to register an arbitrary binding (i.e. to a java
     * bean)
     * 
     * @param binding
     */
    void registerValueBinding(ElementBinding binding);
}
