package bizrules.registry;

import xmldoc.DocumentEventType;
import xmldoc.ElementReference;
import bizrules.BusinessRule;

/**
 * This interface exposes the methods that a BusinessRule might need to chain a
 * new rule instance, specifically when handling forward references out of
 * repeated structures.
 * 
 * @author doug
 * @since 11 June 2007
 * 
 * @see bizrules.registry.BusinessRuleRegistry
 */
public interface BusinessRuleRegistryAccess {

    /**
     * Register a new rule. This behaves exactly the same as the method of the
     * same name in BusinessRuleRegistry.
     */
    void registerBusinessRule(BusinessRule rule);

    /**
     * Locate and remove a value binding that matches the parameters. No error
     * will be raised if no matching binding is found - the method will just
     * return silently.
     */
    void removeElementValueBinding(Object boundObject, ElementReference reference, String boundTo);

    /**
     * Locate and remove an event binding that matches the parameters. No error
     * will be raised if no matching binding is found - the method will just
     * return silently.
     */
    void removeDocumentEventBinding(Object boundObject, ElementReference reference, String boundTo, DocumentEventType eventType);
}
