/**
 * 
 */
package bizrules.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import xmldoc.ElementReference;
import bizrules.binding.DocumentErrorBinding;

/**
 * @author doug
 * 
 */
public class ErrorHandlerRegistry implements ErrorHandlerCatalog {

    /**
     * Error bindings give rules a chance to intercept XML and Schema errors and
     * convert them to BusinessRuleErrors.
     */
    private final Map<ElementReference, List<DocumentErrorBinding>> errorBindings = new HashMap<ElementReference, List<DocumentErrorBinding>>();

    public void addErrorBinding(final DocumentErrorBinding binding) {
        final List<DocumentErrorBinding> bindingList;
        if (errorBindings.containsKey(binding.getReference())) {
            bindingList = errorBindings.get(binding.getReference());
        } else {
            bindingList = new ArrayList<DocumentErrorBinding>();
            errorBindings.put(binding.getReference(), bindingList);
        }

        bindingList.add(binding);
    }

    public List<DocumentErrorBinding> lookupErrorBindings(final ElementReference elementRef) {
        final List<DocumentErrorBinding> result;

        if (errorBindings.containsKey(elementRef)) {
            final List<DocumentErrorBinding> bindings = errorBindings.get(elementRef);
            result = new ArrayList<DocumentErrorBinding>();
            for (int i = 0; i < bindings.size(); i++) {
                final DocumentErrorBinding binding = bindings.get(i);
                if (binding.isActive()) {
                    result.add(binding);
                }
            }
        } else {
            result = Collections.emptyList();
        }

        return result;
    }
}
