/*
 * $Id: StartElementDetail.java,v 1.3 2006/08/10 15:19:11 dec Exp $ 
 */
package bizrules.registry;

import xmldoc.Attribute;
import xmldoc.ElementReference;

/**
 * @author doug
 * 
 */
public class StartElementDetail implements DocumentEventDetail {
    private final ElementReference elementReference;

    private final ElementReference parentElementReference;

    private final Attribute[] attributes;

    public StartElementDetail(final ElementReference parentElementReference, final ElementReference elementReference,
            Attribute[] attributes) {
        this.parentElementReference = parentElementReference;
        this.elementReference = elementReference;
        this.attributes = attributes;
    }

    public StartElementDetail(ElementReference parentElementReference, ElementReference elementReference) {
        this(parentElementReference, elementReference, new Attribute[] {});
    }

    public ElementReference getElementReference() {
        return elementReference;
    }

    public ElementReference getParentElementReference() {
        return parentElementReference;
    }

    public Attribute[] getAttributes() {
        return attributes;
    }
}
