package bizrules.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

import bizrules.BusinessRule;
import bizrules.params.BizrulesParams;

import com.gsl.logging.LoggerFactory;
import com.gsl.util.classlookup.CachingClassInstanceCollector;
import com.gsl.util.classlookup.ClassNameCollector;
import com.gsl.util.classlookup.CompositeInterfaceCollector;
import com.gsl.util.classlookup.InterfaceInstanceCollector;

public class BusinessRuleCollector {

    private static final Logger logger = LoggerFactory.getLogger("bizrules.setup");

    @SuppressWarnings("unchecked")
    public static final List<BusinessRule> collectRules(final String basePackageName, final BizrulesParams params) {
        ClassNameCollector baseCollector;
        final Class<BusinessRule> interfaceToCollect = BusinessRule.class;

        if (params.getForceDynamicClassCollection()) {
            baseCollector = new InterfaceInstanceCollector(basePackageName, interfaceToCollect);
        } else {
            baseCollector = new CompositeInterfaceCollector(basePackageName, interfaceToCollect);
        }

        final CachingClassInstanceCollector collector = new CachingClassInstanceCollector(baseCollector);
        final Collection<Class<?>> classes = collector.collectClasses();

        if (classes.size() == 0) {
            logger.severe("No business rules were found in " + basePackageName);
        }

        final List<BusinessRule> rules = new ArrayList<BusinessRule>(classes.size());
        for (final Object element : classes) {
            final Class<BusinessRule> ruleClass = (Class<BusinessRule>) element;
            try {
                rules.add(ruleClass.newInstance());
            } catch (final InstantiationException e) {
                logger.warning("Could not instantiate rule class " + ruleClass.getName());
            } catch (final IllegalAccessException e) {
                logger.warning("Could not access rule class " + ruleClass.getName());
            }
        }

        return rules;
    }
}
