/**
 * 
 */
package chris.header;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.DocumentErrorFilter;

/**
 * Filter any errors which are within ChRISEnvelope namespace.
 * 
 */
public class ChRISEnvelopeFilter implements DocumentErrorFilter {

    public boolean collectError(final DocumentError e) {
        boolean result = true;

        final ElementReference elementRef = e.getElementReference();
        if (elementRef != null) {
            final String elementNamespace = elementRef.getNamespaceURL();
            if (ChRISHeaderConstants.NAMESPACE_CHRIS_ENVELOPE.equals(elementNamespace)) {
                result = false;
            }
        }

        return result;
    }
}
