package com.gsl.docValidator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.gsl.docValidator.CurrentDate;
import com.gsl.docValidator.ValidationParams;

/**
 * Contains useful code for testing validator implementations.
 * 
 * @author jesse
 */
public class DocValidatorTestUtil {

    /**
     * This constant may be used by test code to pin the current date time to a
     * known value.
     * 
     * @see ValidationParams#setCurrentDate(Date)
     * @see CurrentDate#getCurrentDate()
     */
    public static final Date NOW;

    static {
        Date now = null;
        try {
            now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse("2006-12-04 15:47:29.910");
        } catch (final ParseException e) {
            e.printStackTrace();
        }
        NOW = now;
    }
}
