package com.gsl.docValidator;

import java.util.List;

import processingError.ProcessingError;

/**
 * The framework delegates to an instance of this class once the parse is
 * complete and all the validation errors in the input document have been
 * collected. The instance to delegate to can be provided in one of three ways.
 * First, it may be provided when the validator is invoked. This is the normal
 * approach. Second, a ValidatorProvider may set it onto the validator during
 * validation. Third, it may be left null, in which case a default
 * implementation will be used that just creates and returns an instance of
 * ValidationResultBean.
 * 
 * @author jesse
 */
public interface PostValidationDelegate {

    /**
     * Creates a validation result given a list of processing errors.
     * Implementations should generally instantiate a custom subclass of
     * ValidationResultBean and populate it with any validator specific
     * information that can be derived from the given processing errors.
     * 
     * @param processingErrors
     *            The list of processing errors collected during validation (may
     *            be empty if the input document was valid)
     * @param params
     *            The validation parameters for the current validation.
     * 
     * @return An instance of ValidationResultBean (or more likely a subclass)
     *         containing the validation result information.
     */
    ValidationResultInterface createResult(List<ProcessingError> processingErrors, ValidationParams params);
}
