package com.gsl.docValidator;

import java.io.Serializable;
import java.util.List;

import processingError.ProcessingError;

/**
 * Provides an accessor-only interface to the validation result information.
 * Implementations may wish to make use of this interface to hide the setter
 * methods on the ValidationResultBean class from the calling client.
 * 
 * @see ValidationResultBean
 * 
 * @author jesse
 */
public interface ValidationResult extends Serializable {

    /**
     * Gets the length of time taken to complete the document validation and
     * create this result.
     * <p>
     * The value returned is in milliseconds.
     * 
     * @return The length of time taken to do the validation and create the
     *         result, in milliseconds.
     */
    long getProcessingTime();

    /**
     * Gets the list of {@link ProcessingError} instances containing the errors
     * generated while validating the document. Returns an empty list if there
     * were no errors found.
     * 
     * @return The list of processing errors generated while validating the
     *         document.
     */
    List<ProcessingError> getProcessingErrors();
}
