package com.gsl.docValidator;

import java.util.List;

import processingError.ProcessingError;

/**
 * Base class for returning validation results from the validation framework
 * back to the client.
 * <p>
 * This class should be extended by validator implementations wishing to cater
 * for document-type specific validation result information.
 * 
 * @see ValidationResult
 * 
 * @author jesse
 */
public class ValidationResultBean implements ValidationResultInterface {

    private static final long serialVersionUID = -626073641504745316L;

    private transient long processingTime = -1;

    private transient List<ProcessingError> processingErrors;

    public ValidationResultBean() {
    }

    public long getProcessingTime() {
        return processingTime;
    }

    public void setProcessingTime(final long processingTime) {
        this.processingTime = processingTime;
    }

    public List<ProcessingError> getProcessingErrors() {
        return processingErrors;
    }

    public void setProcessingErrors(final List<ProcessingError> processingErrors) {
        this.processingErrors = processingErrors;
    }
}
