/**
 * $Id: ExclusionFilter.java,v 1.1 2006/02/16 12:18:19 dec Exp $
 */
package com.gsl.io.core.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;

/**
 * @author Douglas Clinton
 * @since Feb 16, 2006
 * 
 */
public class ExclusionFilter implements FilenameFilter {
    private final Set<String> namesToExclude;

    private final FilenameFilter chainedFilter;

    public ExclusionFilter(final Set<String> namesToExclude, final FilenameFilter chainedFilter) {
        this.namesToExclude = namesToExclude;
        this.chainedFilter = chainedFilter;
    }

    public boolean accept(final File dir, final String name) {
        return !namesToExclude.contains(name) && chainedFilter.accept(dir, name);
    }

}
