/*
 * Created on Oct 9, 2005
 *
 * $Id: FileProvider.java,v 1.2 2005/10/11 09:58:05 dec Exp $
 */
package com.gsl.io.core.file;

import java.io.File;

/**
 * A FileProvider gives access to a list of File objects according to some
 * algorithm defined by the implemenation. This can be used to separate the
 * location and listing of files from an object which wishes to use Files.
 * 
 * This is especially useful if you want to feed a list of files to multiple
 * threads. The implemenation should provide a synchronized getNextFile() method
 * in this case.
 * 
 * @author douglas
 * @since Oct 9, 2005
 */
public interface FileProvider {
    /**
     * @return the next File object or null if there are no more Files.
     */
    File getNextFile();

    /**
     * @return the total number of Files which will be provided.
     */
    long getFileCount();

    /**
     * @return the number of Files already provided by this provider
     */
    long getProvidedCount();
}