/*
 * Created on Oct 9, 2005
 *
 * $Id: RecursiveFileSelector.java,v 1.2 2006/03/08 10:17:08 dec Exp $
 */
package com.gsl.io.core.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import java.util.TreeSet;

/**
 * @author douglas
 * @since Oct 9, 2005
 */
public class RecursiveFileSelector implements FileSelector {
    private final FilenameFilter filter;

    public RecursiveFileSelector(final FilenameFilter filter) {
        this.filter = filter;
    }

    /**
     * Find all matching files in the given directory and recurisvely descend
     * into subdirectories.
     */
    public Set<File> selectFiles(final File baseDir) {
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException(baseDir.getName() + " is not a directory");
        }
        final Set<File> result = new TreeSet<File>();

        final File[] files = baseDir.listFiles();
        for (final File element : files) {
            if (element.isDirectory()) {
                result.addAll(selectFiles(element));
            } else if (element.isFile()) {
                if (filter.accept(baseDir, element.getName())) {
                    result.add(element);
                }
            }
        }

        return result;
    }

}
