package com.gsl.io.core.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class RegexFilenameFilter implements FilenameFilter {

    private final Pattern pattern;

    public RegexFilenameFilter(final String pattern) {
        this(Pattern.compile(pattern));
    }

    public RegexFilenameFilter(final Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean accept(final File dir, final String name) {
        return pattern.matcher(name).matches();
    }
}
