/**
 * 
 */
package com.gsl.io.core.stream;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author Doug Clinton
 * 
 */
public class ByteCountingInputStream extends InputStream {
    private long count = 0;

    private final InputStream underlyingStream;

    public ByteCountingInputStream(final InputStream underlyingStream) {
        super();
        this.underlyingStream = underlyingStream;
    }

    @Override
    public int read() throws IOException {
        final int nextChar = underlyingStream.read();
        if (nextChar != -1) {
            count++;
        }
        return nextChar;
    }

    public long getCount() {
        return count;
    }

}
