/**
 * 
 */
package com.gsl.io.core.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author doug
 * 
 */
public class FileStreamable implements Streamable {
    private final File file;

    public FileStreamable(final File file) {
        this.file = file;
    }

    public FileStreamable(final String fileName) {
        this.file = new File(fileName);
    }

    public String getLocation() {
        return file.getPath();
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(file);
    }

}
