/*
 * Created on 08-Dec-2005
 * 
 * $Id: ReaderInputStream.java,v 1.1 2005/12/08 17:26:17 dec Exp $
 */
package com.gsl.io.core.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

/**
 * Adapts a reader to an input stream. Currently only implements the single-char
 * read() method which is pretty inefficient.
 * 
 * @author Douglas Clinton
 * @since 08-Dec-2005
 */
public class ReaderInputStream extends InputStream {
    private final Reader underlyingReader;

    public ReaderInputStream(final Reader underlyingReader) {
        super();
        this.underlyingReader = underlyingReader;
    }

    @Override
    public int read() throws IOException {
        return underlyingReader.read();
    }
}
