/**
 * 
 */
package com.gsl.io.core.stream;

import java.io.IOException;
import java.io.InputStream;

/**
 * Describes something that can be streamed (in only).
 * 
 * @author doug
 * 
 */
public interface Streamable {
    /**
     * Open a fresh InputStream from which we can read the Streamble. It is the
     * caller's responsibility to close the stream at an appropriate point.
     * 
     * @throws IOException
     */
    InputStream openInputStream() throws IOException;

    /**
     * @return a string representation of how something can locate the
     *         streamable resource. Might be a URL, or a file path, or whatever.
     */
    String getLocation();
}
