package com.gsl.io.core.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StringStreamable implements Streamable {

    private final String string;

    private final String location;

    public StringStreamable(final String string) {
        this(string, "");
    }

    public StringStreamable(final String string, final String location) {
        this.string = string;
        this.location = location;
    }

    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(string.getBytes());
    }

    public String getLocation() {
        return location;
    }
}
