/*
 * Created on Jul 21, 2005
 *
 * $Id: WriterOutputStream.java,v 1.1 2005/07/21 22:57:02 dec Exp $
 */
package com.gsl.io.core.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

/**
 * The java.io library provides an OutputStreamWriter which converts from an
 * OutputStream to a Writer, but fails to provide the converse - an OutputStream
 * which will write to a Writer. This class fills the void.
 * 
 * @author doug
 * @since Jul 21, 2005
 */
public class WriterOutputStream extends OutputStream {
    private final Writer writer;

    private final char[] buffer;

    public WriterOutputStream(final Writer writer) {
        this(writer, 8192);
    }

    public WriterOutputStream(final Writer writer, final int bufferSize) {
        super();

        if (writer == null) {
            throw new IllegalArgumentException("Cannot instantiate WriteOutputStream with null");
        }

        buffer = new char[bufferSize];

        this.writer = writer;
    }

    @Override
    public void write(final int charToWrite) throws IOException {
        writer.write(charToWrite);
    }

    public void dontwrite(final byte[] bytes, final int off, final int len) throws IOException {
        int j = 0;
        int i = off;
        final int lastByteToWrite = off + len;

        // Maybe our buffer is smaller than the amount of data to write.
        // If so, loop around filling up our buffer until we're done
        while (i < lastByteToWrite) {
            for (; i < len && j < buffer.length; i++) {
                buffer[j++] = (char) bytes[i];
            }
            writer.write(buffer, 0, len);
        }
    }

    public void dontwrite(final byte[] bytes) throws IOException {
        write(bytes, 0, bytes.length);
    }
}
