/*
 * Created on 02-Dec-2005
 * 
 * $Id: LoggingParams.java,v 1.6 2006/01/20 17:07:58 dec Exp $
 */
package com.gsl.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/**
 * $Id: LoggingParams.java,v 1.6 2006/01/20 17:07:58 dec Exp $
 */
public class LoggingParams implements Cloneable {
    private Map<String, Level> logLevels = new HashMap<String, Level>();

    /**
     * Will be used in logging messages for tracing
     */
    private String idString;

    public Map<String, Level> getLogLevels() {
        return logLevels;
    }

    public void setLogLevels(final Map<String, Level> logLevels) {
        this.logLevels = logLevels;
    }

    /**
     * This will set the default level for subsequently created loggers if no
     * explicit level has been set. Note that a call to setLogLevels() following
     * this will override the default, or wipe it out if no default is provided
     * in the new map.
     * 
     * @param defaultLevel
     *            default level to set.
     */
    public void setDefaultLevel(final Level defaultLevel) {
        logLevels.put("default", defaultLevel);
    }

    public String getIdString() {
        return idString;
    }

    public void setIdString(final String idString) {
        this.idString = idString;
    }

    @Override
    public String toString() {
        String s = "LoggingParams [";
        s += "idString=" + idString;
        s += ", ";
        s += "logLevels=" + logLevels;
        s += "]";

        return s;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        final LoggingParams clone = (LoggingParams) super.clone();
        clone.logLevels = new HashMap<String, Level>(logLevels);

        return clone;
    }
}
