/**
 * 
 */
package com.gsl.reader.nscorrect;

import java.io.BufferedReader;
import java.io.StringReader;

import junit.framework.TestCase;
import paye.multiyear.TaxYear;

/**
 * @author doug
 * 
 */
public class NamespaceCorrectingReaderTest extends TestCase {

    public void testInactive() throws Exception {
        final String expected = "foo";
        final StringReader sr = new StringReader(expected);

        // Namespace from 0405 is the unversioned one so the ncr should just
        // read through to the underlying reader.
        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_0405);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

    public void testActive() throws Exception {
        final String input = "\"http://www.govtalk.gov.uk/taxation/EOY\"";
        final String expected = "\"http://www.govtalk.gov.uk/taxation/EOY/10-11/1\"";

        final StringReader sr = new StringReader(input);

        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_1011);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

    public void test2() throws Exception {
        final String input = "xmlns=\"http://www.govtalk.gov.uk/taxation/EOY\"";
        final String expected = "xmlns=\"http://www.govtalk.gov.uk/taxation/EOY/10-11/1\"";

        final StringReader sr = new StringReader(input);

        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_1011);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

    public void test3() throws Exception {
        final String input = "xmlns=\"http://www.govtalk.gov.uk/taxation/EO\">foo";
        final String expected = "xmlns=\"http://www.govtalk.gov.uk/taxation/EO\">foo";

        final StringReader sr = new StringReader(input);

        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_1011);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

    public void test4() throws Exception {
        final String input = "xmlns=\"http://www.govtalk.gov.uk/taxation/EO\">foo";
        final String expected = input;

        final StringReader sr = new StringReader(input);

        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_1011);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

    public void test5() throws Exception {
        final String input = "xmlns=\"http://www.govtalk.gov.uk/taxation/EOY/10-11/1\">foo";
        final String expected = input;

        final StringReader sr = new StringReader(input);

        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_1011);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

    public void test6() throws Exception {
        final String input = "xmlns=\"http://www.gov\"http://www.govtalk.gov.uk/taxation/EOY\"></foo>";
        final String expected = "xmlns=\"http://www.gov\"http://www.govtalk.gov.uk/taxation/EOY/10-11/1\"></foo>";

        final StringReader sr = new StringReader(input);

        final NamespaceCorrectingReader ncr = new NamespaceCorrectingReader(sr, TaxYear.TAX_YEAR_1011);

        final BufferedReader br = new BufferedReader(ncr);
        assertEquals(expected, br.readLine());
    }

}
