/**
 * $Id: AbstractXercesErrorDecoder.java,v 1.3 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces;

import org.xml.sax.SAXParseException;

import processingError.Location;
import xmldoc.DocumentErrorBean;
import xmldoc.DocumentLocation;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import xmldoc.sax.DocumentErrorPostProcessor;
import xmldoc.sax.NullErrorPostProcessor;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public abstract class AbstractXercesErrorDecoder implements XercesErrorDecoder {

    private DocumentErrorPostProcessor errorPostProcessor = NullErrorPostProcessor.INSTANCE;

    protected DocumentErrorBean makeDocumentError(final SAXParseException ex, final ElementReference resultRef, final String code,
            final String valueInError) {
        DocumentErrorBean result;
        final Location location = new DocumentLocation(ex, resultRef);
        result = new DocumentErrorBean(location);
        result.setElementReference(resultRef);
        result.setUnderlyingError(ex);
        result.setErrorProcessor(this);
        result.setSubCode(code);
        result.setValueInError(valueInError);
        return result;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void setErrorPostProcessor(final DocumentErrorPostProcessor postProcessor) {
        this.errorPostProcessor = postProcessor;
    }

    public DocumentErrorPostProcessor getErrorPostProcessor() {
        return errorPostProcessor;
    }

    /**
     * Check if the element reference supplied needs to be modified up based on
     * the content of the error message to more accurately reflect the position
     * of the error.
     * 
     * @param elementRef
     *            location reported by the XML processor for the error.
     * @param errorText
     *            message text from the parser error
     * @param preceedingString
     *            the text which preceeds the element name in the error text.
     * @param terminatingString
     *            the text which follows the element name in the error text.
     * @return an ElementReference which may have had its xpath fixed up. If no
     *         fix was needed then this will be the same ElementReference object
     *         which was passed in.
     */
    protected ElementReference fixupElementReference(final ElementReference elementRef, final String errorText,
            final String preceedingString, final String terminatingString) {
        ElementReference result = elementRef;

        String elementName = extractString(errorText, preceedingString, terminatingString);
        if (elementName.contains(":")) {
            elementName = elementName.split(":")[1];
        }
        final String xPath = elementRef.getXPath();
        final String referenceElement = xPath.substring(xPath.lastIndexOf('/') + 1);

        if (!referenceElement.equals(elementName)) {
            result = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), elementRef.getXPath() + "/" + elementName);
        }
        return result;
    }

    protected String extractString(final String text, final String preceedingString, final String terminatingString) {
        final int substringStart = text.indexOf(preceedingString) + preceedingString.length();
        final int substringEnd = text.indexOf(terminatingString, substringStart);
        final String extractedString = text.substring(substringStart, substringEnd);
        return extractedString;
    }
}
