/**
 * 
 */
package com.gsl.sax.decoder.xerces;

import xmldoc.DocumentError;
import xmldoc.DocumentErrorBean;
import xmldoc.DocumentLocation;
import xmldoc.SimpleElementReference;

/**
 * This object holds state to needed coordinate the error decoders so that they
 * can suppress or modify the errors they return to eliminate duplicates.
 * 
 * @author Doug Clinton
 * 
 */
public class ErrorDecoderState {
    private DocumentError mostRecentError;

    private final DocumentErrorBean placeholderError;

    public ErrorDecoderState() {
        placeholderError = new DocumentErrorBean(new DocumentLocation(0, 0, ""));
        placeholderError.setElementReference(SimpleElementReference.makeReference("", ""));

        mostRecentError = placeholderError;
    }

    public DocumentError getMostRecentError() {
        return mostRecentError;
    }

    public void setMostRecentError(final DocumentError mostRecentError) {
        this.mostRecentError = mostRecentError;
    }

    public void reset() {
        mostRecentError = placeholderError;
    }
}
