package com.gsl.sax.decoder.xerces;

import org.xml.sax.SAXParseException;

import processingError.ErrorProcessor;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.DocumentErrorPostProcessor;

/**
 * Each of the individual decoders used by the XercesExceptionDecoder will
 * implement this interface.
 * 
 * @author douglas
 * @since Mar 28, 2006
 */
public interface XercesErrorDecoder extends ErrorProcessor {

    /**
     * @return True if this decoder is able to decode the given exception.
     */
    boolean canDecode(SAXParseException ex);

    /**
     * @return a DocumentError derived from the SAXParseException and
     *         ElementReference.
     */
    DocumentError decodeError(SAXParseException ex, ElementReference elementRef);

    void setErrorPostProcessor(DocumentErrorPostProcessor errorPostProcessor);
}
