/**
 * $Id: CVCAttributeDecoder.java,v 1.3 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.chris;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;

/**
 * @author Douglas Clinton
 * @since Mar 28, 2006
 * 
 */
public class CVCAttributeDecoder extends AbstractXercesErrorDecoder {

    private final ErrorDecoderState state;

    public CVCAttributeDecoder(final ErrorDecoderState state) {
        this.state = state;
    }

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-attribute.3:") || ex.getMessage().startsWith("cvc-complex-type.4:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String messageText = ex.getMessage();

        // Sometimes 'Attribute' and sometimes 'attribute' so lowercase it to
        // neutralise
        final int attributeNameStart = messageText.toLowerCase().indexOf("attribute '") + 11;
        final int attributeNameEnd = messageText.indexOf("'", attributeNameStart);
        final String attributeName = messageText.substring(attributeNameStart, attributeNameEnd);

        /*
         * If the previuos error was a cvc-pattern-valid or a
         * cvc-enumeration-valid error on the same incoming elementReference
         * then the message for that error did not have enough information to
         * fix up the element reference so it would have been reported on the
         * parent tag of the real element. We detect this condition here and fix
         * up the location on that error as well.
         */
        final DocumentError mostRecentError = state.getMostRecentError();
        final String mostRecentCode = mostRecentError.getSubCode();
        if (mostRecentError.getElementReference().equals(elementRef)) {
            if (mostRecentCode.equals("cvc-pattern-valid") || mostRecentCode.equals("cvc-enumeration-valid")) {
                mostRecentError.setAttributeName(attributeName);
                getErrorPostProcessor().scheduleErrorForProcessing(mostRecentError);
            }
        }

        final DocumentError result = makeDocumentError(ex, elementRef, DocumentError.ATTRIBUTE, null);
        result.setAttributeName(attributeName);
        getErrorPostProcessor().scheduleErrorForProcessing(result);

        return result;
    }
}
