/**
 * $Id: CVCComplexType22Decoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.chris;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.DocumentErrorPostProcessor.FixupType;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * Deals with cvc-complex-type.2.2
 * 
 * If the field is blank and formatted using the short form element (i.e.
 * <field/>) then the error is reported before the start tag so we need to
 * schedule it for fixup.
 * 
 * @author Douglas Clinton
 * @since May 10, 2012
 * 
 */
public class CVCComplexType22Decoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.2");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        DocumentError error = makeDocumentError(ex, elementRef, DocumentError.FORMAT, null);

        /*
         * If this is a short-form field then the next event that comes in will
         * be a start-element for the actual field that contains the error. If
         * it is not a short-form then the next event will be the end-element
         * for the field, so schedule a fixup which will be cancelled by the
         * end-element.
         */
        getErrorPostProcessor().scheduleErrorForProcessing(error, FixupType.UntilEndElement);

        return error;
    }
}
