/**
 * $Id: CVCComplexType24aDecoder.java,v 1.4 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.chris;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCComplexType24aDecoder extends AbstractXercesErrorDecoder {

    private static final String CVC_COMPLEX_TYPE_2_4_B = "cvc-complex-type.2.4.b";

    private static final String CVC_COMPLEX_TYPE_2_4_A = "cvc-complex-type.2.4.a";

    private final ErrorDecoderState state;

    public CVCComplexType24aDecoder(final ErrorDecoderState state) {
        this.state = state;
    }

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith(CVC_COMPLEX_TYPE_2_4_A);
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final ElementReference resultRef = elementRef;

        /*
         * 2.4.b errors are usually immediately followed by a 2.4.a for the same
         * element. In that case the 2.4.b has the wrong locator and needs to be
         * scheduled for fixing up.
         * 
         * However, it is possible for the 2.4.b to be followed by a 2.4.a from
         * a different element in which case we don't want to do the fix-up.
         */
        final DocumentError mostRecentError = state.getMostRecentError();

        final boolean samePath = mostRecentError.getElementReference().getXPath().equals(elementRef.getXPath());
        if (mostRecentError.getSubCode().equals(CVC_COMPLEX_TYPE_2_4_B) && samePath) {
            getErrorPostProcessor().scheduleErrorForProcessing(mostRecentError);
        }

        final DocumentError result = makeDocumentError(ex, resultRef, CVC_COMPLEX_TYPE_2_4_A, null);
        getErrorPostProcessor().scheduleErrorForProcessing(result);

        return result;
    }
}
