/**
 * $Id: CVCComplexType24bDecoder.java,v 1.3 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.chris;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCComplexType24bDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.4.b");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String errorText = ex.getMessage();
        ElementReference resultRef = elementRef;
        String code = DocumentError.UNKNOWN;

        // With these errors the reference is the parent of the bad
        // element so we need to do some work to identify the cause and to fix
        // up the element reference to identify the bad element.
        final String expectedListString = errorText.substring(errorText.indexOf('{'), errorText.indexOf('}'));
        final String[] expectedList = expectedListString.split(",");
        if (expectedList.length == 1) {
            // If there was only one item listed in the error text then
            // that item must be mandatory, so report it as a missing element.
            final String expectedElement = expectedList[0].substring(expectedList[0].indexOf("\":") + 2);

            final String resultXPath = fixupXPath(elementRef, errorText, expectedElement);

            resultRef = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), resultXPath);
            code = DocumentError.MANDATORY;
        } else {
            code = DocumentError.INVALID;
        }

        return makeDocumentError(ex, resultRef, code, null);
    }

    private String fixupXPath(final ElementReference elementRef, final String errorText, final String expectedElement) {
        // Depending on the form of the broken XML, the intermediate tag may
        // already be present in the reference xpath. If not, fix it up.
        String resultXpath = elementRef.getXPath();
        final String intermediateTag = extractIntermediateTag(errorText);

        if (!resultXpath.endsWith("/" + intermediateTag)) {
            resultXpath += "/" + intermediateTag;
        }
        resultXpath += "/" + expectedElement;
        return resultXpath;
    }

    private String extractIntermediateTag(final String errorText) {
        final int intermediateTagStart = errorText.indexOf('\'') + 1;
        final int intermediateTagEnd = errorText.indexOf('\'', intermediateTagStart);
        final String intermediateTag = errorText.substring(intermediateTagStart, intermediateTagEnd);
        return intermediateTag;
    }
}
